/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.dynamics;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import nl.buildersenperformers.xam.engine.OperationException;

public class AzureLogin {
    private String iClientId = null;
    private String iClientSecret = null;
    private String iResource = null;
    private String iAuthority = null;

    public AzureLogin(String pClientId, String pClientSecret, String pResource, String pAuthority) {
        this.iClientId = pClientId;
        this.iClientSecret = pClientSecret;
        this.iResource = pResource;
        this.iAuthority = pAuthority;
    }

    public String getToken() throws OperationException {
        AuthenticationContext context = null;
        AuthenticationResult result = null;
        ExecutorService service = null;
        ClientCredential cred = new ClientCredential(this.iClientId, this.iClientSecret);
        try {
            service = Executors.newFixedThreadPool(1);
            context = new AuthenticationContext(this.iAuthority, false, service);
            Future future = context.acquireToken(this.iResource, cred, null);
            result = (AuthenticationResult)future.get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw new OperationException("Could not login", (Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        return result.getAccessToken();
    }
}

