/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.dynamics;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.oostnl.ventureplan.jobs.dynamics.AzureLogin;
import nl.ppmoost.ventureplan2.vp_change;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public class SyncProjects
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(SyncProjects.class);
    private Properties iProperties;
    private Map<String, Object> iParams;
    private XamEngine iXE = null;
    private Dataset iDataset;
    private Dataset iProjectDataset;
    private CloseableHttpClient iClient = HttpClients.createDefault();

    public SyncProjects() {
        this.iXE = new XamEngine();
        try {
            this.iProjectDataset = this.iXE.getDataset("Project");
        }
        catch (DatasetException e) {
            throw new RuntimeException(e);
        }
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        List lChanges = null;
        Operation projData = this.iProjectDataset.getOperation("DynamicsData");
        ObjectMapper mapper = new ObjectMapper();
        String token = null;
        String clientId = ConfigurationProperties.get().get("DYNAMICS.client_id");
        String clientSecret = ConfigurationProperties.get().get("DYNAMICS.client_secret");
        String resource = ConfigurationProperties.get().get("DYNAMICS.resource");
        String authority = ConfigurationProperties.get().get("DYNAMICS.authority");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("DYNAMCS.client_id=" + clientId));
            log4j.debug((Object)("DYNAMCS.client_secret=" + clientSecret));
            log4j.debug((Object)("DYNAMCS.resource=" + resource));
            log4j.debug((Object)("DYNAMCS.authority=" + authority));
        }
        String dynamicsUrlBase = resource + "/api/data/v9.0/opportunities";
        lChanges = vp_change.getChanges((String)"vp_project", (String)"dynamics");
        for (vp_change lChange : lChanges) {
            block9: {
                log4j.info((Object)("Processing change: " + lChange.toString()));
                if (token == null) {
                    log4j.info((Object)("First change, get token from " + authority));
                    AzureLogin azureLogin = new AzureLogin(clientId, clientSecret, resource, authority);
                    token = azureLogin.getToken();
                }
                projData.setParameter("proj_id", (Object)lChange.getItemId());
                List lResults = projData.executeAsValueList();
                if (lResults.isEmpty()) {
                    log4j.warn((Object)("Change id: " + lChange.getId() + " has no project data!!!"));
                    lChange.markAsError(8, "No project data");
                    continue;
                }
                StringWriter lBodyJson = new StringWriter();
                String dynamicsUrl = dynamicsUrlBase + "(" + ((Map)lResults.get(0)).get("dynamics_id") + ")";
                ((Map)lResults.get(0)).remove("dynamics_id");
                try {
                    mapper.writeValue((Writer)lBodyJson, lResults.get(0));
                }
                catch (IOException e) {
                    log4j.warn((Object)("Change id: " + lChange.getId() + " has errors when creating body"), (Throwable)e);
                    lChange.markAsError(8, "Error creating body!");
                    continue;
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("JSON body: " + lBodyJson.toString()));
                }
                log4j.info((Object)("Sending change " + lChange.toString() + " data to " + resource));
                HttpPatch patch = new HttpPatch(dynamicsUrl);
                patch.addHeader("Authorization", "Bearer " + token);
                patch.addHeader("Content-Type", "application/json; charset=utf-8");
                patch.addHeader("Accept", "application/json");
                patch.addHeader("OData-MaxVersion", "4.0");
                patch.addHeader("OData-Version", "4.0");
                try {
                    StringEntity body = new StringEntity(lBodyJson.toString(), "UTF-8");
                    patch.setEntity((HttpEntity)body);
                    log4j.info((Object)("Send to url: " + dynamicsUrl));
                    log4j.debug((Object)("-- body: " + patch.toString()));
                    CloseableHttpResponse lGetResponse = this.iClient.execute((HttpUriRequest)patch);
                    if (lGetResponse.getStatusLine().getStatusCode() == 204) break block9;
                    log4j.warn((Object)("Change id: " + lChange.getId() + " has errors when sending body, httpstatus: " + lGetResponse.getStatusLine().getStatusCode()));
                    String lerror = null;
                    IOUtils.toString((InputStream)lGetResponse.getEntity().getContent(), lerror);
                    log4j.warn((Object)("--returnb body: " + lerror));
                    lChange.markAsError(8, "Error sending body, httpstatus: " + lGetResponse.getStatusLine().getStatusCode());
                }
                catch (IOException e) {
                    log4j.warn((Object)("Change id: " + lChange.getId() + " has errors when sending body"), (Throwable)e);
                    lChange.markAsError(8, "Error creating body!");
                    continue;
                }
            }
            lChange.markAsSuccess();
        }
        return null;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "Synchronizes project data to Dynamics";
    }
}

