/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.financial;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.dataset.jdbc.ListGeneric;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.oostnl.ventureplan.jobs.model.VpDocument;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportFinancial
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private Properties iProperties;
    private Map<String, Object> iParams;
    private XamEngine iXE = new XamEngine();
    private Dataset iDataset;
    private Dataset iDocDataset;
    private String iCachePath;
    private Integer iDocId = null;
    private String iSessionId = null;

    public ImportFinancial() {
        try {
            this.iDocDataset = this.iXE.getDataset("Documenten");
        }
        catch (DatasetException e) {
            throw new RuntimeException(e);
        }
        String lCachePath = ConfigurationProperties.get().get("FINANCIAL.CachePath");
        if (lCachePath == null) {
            log4j.error((Object)"FINANCIAL.CachePath not set in configuration");
        }
        this.iCachePath = lCachePath;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Financial import cache directory: " + this.iCachePath));
        }
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        if (pName.equals("doc_id")) {
            this.iDocId = (Integer)pValue;
        } else if (pName.equals("session_id")) {
            this.iSessionId = (String)pValue;
        } else {
            this.iParams.put(pName, pValue);
        }
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    /*
     * Exception decompiling
     */
    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        return null;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "Imports a financial excel sheet and returns the cahced result xml file";
    }

    public void importFile(File file, File outFile) throws OperationException {
        try (FileOutputStream out = new FileOutputStream(outFile);
             FileInputStream fileStream = new FileInputStream(file);){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileStream);
            XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            Locale dutch = Locale.forLanguageTag("nl-NL");
            DataFormatter formatter = new DataFormatter(dutch);
            int dashboardPos = workbook.getSheetIndex("Dashboard");
            if (dashboardPos == -1) {
                throw new OperationException("Dashboard sheet not found in file " + file.getAbsolutePath());
            }
            XSSFSheet sheet = workbook.getSheetAt(dashboardPos);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("table");
            doc.appendChild(rootElement);
            for (int i = 9; i <= 25; ++i) {
                XSSFRow row = sheet.getRow(i);
                Element rowElem = doc.createElement("row");
                rootElement.appendChild(rowElem);
                for (int j = 0; j <= 10; ++j) {
                    Cell cell;
                    if (j == 1 || (cell = row.getCell(j, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)) == null) continue;
                    int colspan = this.getCollspan(cell, sheet);
                    if (cell.getCellType() == CellType.BLANK && colspan > 1) continue;
                    Element cellElem = doc.createElement("cell");
                    rowElem.appendChild(cellElem);
                    cellElem.setAttribute("colspan", String.valueOf(colspan));
                    StringBuilder classStr = new StringBuilder();
                    int fontIndex = cell.getCellStyle().getFontIndexAsInt();
                    XSSFFont font = workbook.getFontAt(fontIndex);
                    if (font.getBold()) {
                        classStr.append("bold ");
                    }
                    if (font.getItalic()) {
                        classStr.append("italic");
                    }
                    switch (cell.getCellStyle().getAlignment()) {
                        case CENTER: {
                            classStr.append("align-center ");
                            break;
                        }
                        case RIGHT: {
                            classStr.append("align-right ");
                            break;
                        }
                        case CENTER_SELECTION: {
                            classStr.append("align-center ");
                            break;
                        }
                        default: {
                            if (cell.getCellType() != CellType.NUMERIC && (cell.getCellType() != CellType.FORMULA || cell.getCachedFormulaResultType() != CellType.NUMERIC)) break;
                            classStr.append("align-right ");
                        }
                    }
                    Element value = doc.createElement("value");
                    cellElem.appendChild(value);
                    if (cell.getCellType() == CellType.FORMULA) {
                        value.setTextContent(formatter.formatCellValue(cell, (FormulaEvaluator)evaluator));
                    } else {
                        value.setTextContent(formatter.formatCellValue(cell));
                    }
                    cellElem.setAttribute("class", classStr.toString());
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (log4j.isDebugEnabled()) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            log4j.error((Object)("Could not open file: " + file.getAbsoluteFile()), (Throwable)e);
            throw new OperationException("Could not open file: " + file.getAbsoluteFile(), (Throwable)e);
        }
        catch (ParserConfigurationException | TransformerException e) {
            log4j.error((Object)("Could not write to file: " + outFile.getAbsoluteFile()), (Throwable)e);
            throw new OperationException("Could not write to file: " + outFile.getAbsoluteFile(), (Throwable)e);
        }
    }

    private int getCollspan(Cell cell, XSSFSheet sheet) {
        for (CellRangeAddress region : sheet.getMergedRegions()) {
            if (!region.isInRange(cell)) continue;
            return 1 + region.getLastColumn() - region.getFirstColumn();
        }
        return 1;
    }

    public VpDocument getDocument(Integer pDocId) throws OperationException {
        XamEngine lXE = new XamEngine();
        try {
            Dataset lDS = lXE.getDataset("Documenten");
            Operation lOper = lDS.getOperation("GetDocument");
            lOper.setParameter("doc_id", (Object)pDocId);
            ListGeneric<VpDocument> lDocOper = new ListGeneric<VpDocument>(lOper){};
            List docs = lDocOper.execute();
            if (docs == null || docs.isEmpty()) {
                throw new OperationException("Doc not found");
            }
            return (VpDocument)docs.get(0);
        }
        catch (DatasetException e) {
            throw new OperationException((Throwable)e);
        }
    }
}

