/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.finfact;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.groenfonds.jobs.interest.MonthylyInterestRevenueOperation;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class DailyFinfact
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyInterestRevenueOperation.class);
    private static final String cRunDate = "rundate";
    private XamEngine iXE = new XamEngine();
    private Dataset iFinFact;
    private Dataset iDataset;
    private Dataset iMedewerkers;
    private Map<String, Object> iParams;
    private Properties iProperties;

    public DailyFinfact() throws OperationException {
        try {
            this.iFinFact = this.iXE.getDataset("FinFact");
            this.iMedewerkers = this.iXE.getDataset("Medewerker");
        }
        catch (DatasetException e) {
            throw new OperationException((Throwable)e);
        }
        this.iParams = new HashMap<String, Object>();
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        ArrayList<Map<String, Object>> lRetVal = new ArrayList<Map<String, Object>>();
        Operation lFFRegels = this.iFinFact.getOperation("CountFinfactErrors");
        lFFRegels.setParameter(cRunDate, this.iParams.get(cRunDate));
        ResultSet lRCRentes = lFFRegels.executeAsResultset();
        String lProc = "Rapporteer niet verwerkte fin.feiten aangemaakt op: " + this.iParams.get(cRunDate);
        PROCESS_LOGGER.start(lProc);
        try {
            if (lRCRentes.next()) {
                log4j.info((Object)("Fouten gevonden: " + lRCRentes.getInt("aantal")));
                if (lRCRentes.getInt("aantal") > 0) {
                    ArrayList<String> lEmail = new ArrayList<String>();
                    Operation lMedewerkers = this.iMedewerkers.getOperation("ListMedewerker");
                    lMedewerkers.setParameter("roles", (Object)"FB,CON");
                    ResultSet lRSMedewerkers = lMedewerkers.executeAsResultset();
                    while (lRSMedewerkers.next()) {
                        lEmail.add(lRSMedewerkers.getString("EMAILADDRESS"));
                    }
                    log4j.info((Object)("Stuur email naar: " + String.join((CharSequence)";", lEmail)));
                    Operation lSendEmail = this.iFinFact.getOperation("SendEmail");
                    lSendEmail.setParameter("to", (Object)String.join((CharSequence)";", lEmail));
                    lSendEmail.setParameter(cRunDate, this.iParams.get(cRunDate));
                    lSendEmail.executeAsValueMap();
                    Operation lFinFactRows = this.iFinFact.getOperation("ListFinfactErrorMedewerker");
                    lFinFactRows.setParameter(cRunDate, this.iParams.get(cRunDate));
                    ResultSet lRSFinFactRows = lFinFactRows.executeAsResultset();
                    while (lRSFinFactRows.next()) {
                        log4j.info((Object)("Stuur email naar: " + lRSFinFactRows.getString("EMAILADDRESS")));
                        lSendEmail.setParameter("to", (Object)lRSFinFactRows.getString("EMAILADDRESS"));
                        lSendEmail.setParameter(cRunDate, this.iParams.get(cRunDate));
                        lSendEmail.setParameter("medewerker_id", (Object)lRSFinFactRows.getString("MEDEWERKER_ID"));
                        lSendEmail.executeAsValueMap();
                    }
                }
            }
            PROCESS_LOGGER.complete(lProc);
            return lRetVal;
        }
        catch (SQLException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDS) {
        this.iDataset = pDS;
    }

    public String getDescription() {
        return "Send a daily report with missing finfacts in the journal log";
    }
}

