/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.finfact;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.groenfonds.jobs.interest.MonthylyInterestRevenueOperation;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.ppmoost.ventureplan2.servlets.TaskServlet;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class GenerateFactuur
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyInterestRevenueOperation.class);
    private static final String cRunDate = "rundate";
    private static final String cUserId = "user_id";
    private Dataset iDataset;
    private Map<String, Object> iParams;
    private Properties iProperties;
    private Dataset iDsFactuur = null;
    private XamEngine iXE = null;
    private HttpClient client;
    private static MultiThreadedHttpConnectionManager connMan;
    private String iLocalBase = null;
    private String iSession = null;
    private TaskServlet iTask = new TaskServlet();

    public GenerateFactuur() throws OperationException {
        this.iXE = new XamEngine();
        this.iParams = new HashMap<String, Object>();
        try {
            this.iDsFactuur = this.iXE.getDataset("Factuur");
        }
        catch (DatasetException e) {
            throw new OperationException((Throwable)e);
        }
        connMan = new MultiThreadedHttpConnectionManager();
        this.client = new HttpClient((HttpConnectionManager)connMan);
        this.iLocalBase = ConfigurationProperties.get().get("LOCAL_BASE");
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return true;
    }

    public ResultSet executeAsResultset() throws OperationException {
        PROCESS_LOGGER.start("Generate facturen", 1);
        Integer taskId = (Integer)this.iParams.get("task_id");
        this.httpLogin();
        Operation lLeningdelen = this.iDsFactuur.getOperation("ListLeningDelen");
        lLeningdelen.setParameter("task_id", (Object)taskId);
        ResultSet lRCLening = lLeningdelen.executeAsResultset();
        try {
            while (lRCLening.next()) {
                PROCESS_LOGGER.start("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
                if (lRCLening.getInt("has_templates") > 0) {
                    int lTaskId = this.createVpTask(taskId, lRCLening.getInt("ORG_ID"), lRCLening.getInt("PROJ_ID"), lRCLening.getInt("FR_ID"), lRCLening.getInt("MEDEWERKER_ID"), lRCLening.getInt("NOTA_ID"), lRCLening.getString("RUNDATE"), lRCLening.getString("TEMPLATE_TYPE"), lRCLening.getString("FACTS"), lRCLening.getString("FACTUUR_NR"));
                    this.executeVpTask(lTaskId);
                    PROCESS_LOGGER.complete("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
                    continue;
                }
                this.skipFactuur(taskId, lRCLening.getInt("NOTA_ID"));
                PROCESS_LOGGER.skip("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
            }
            PROCESS_LOGGER.complete("Generate Account Statement", 1);
            return lRCLening;
        }
        catch (SQLException e) {
            String message = "Error Generating Account Statement";
            log4j.error((Object)message, (Throwable)e);
            throw new OperationException(message, (Throwable)e);
        }
    }

    private void httpLogin() throws OperationException {
        String lUser = ConfigurationProperties.get().get("Cheyenne.username");
        String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
        String lUrl = this.iLocalBase + "/cheyenne?cddid=main&cmode=kpwindow_ventureplan";
        lUrl = lUrl + "&_username=" + lUser + "&_passwd=" + lPassword;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Logging in with url: " + lUrl));
        }
        GetMethod get = new GetMethod(lUrl);
        try {
            Cookie[] lCookies;
            int statusCode = this.client.executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                log4j.error((Object)("Method failed: " + get.getStatusLine()));
                String lContent = get.getResponseBodyAsString();
                log4j.info((Object)("Method body: \n" + lContent));
                throw new OperationException("Method failed: " + get.getStatusLine());
            }
            HttpState state = this.client.getState();
            for (Cookie lCookie : lCookies = state.getCookies()) {
                if (!lCookie.getName().equals("JSESSIONID")) continue;
                log4j.info((Object)("Got session id: " + lCookie.getValue()));
                this.iSession = lCookie.getValue();
            }
        }
        catch (IOException e) {
            String msg = "Error logging in";
            log4j.error((Object)msg, (Throwable)e);
            throw new OperationException(msg, (Throwable)e);
        }
    }

    private void httpLogout() throws OperationException {
        String lUser = ConfigurationProperties.get().get("Cheyenne.username");
        String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
        String lUrl = this.iLocalBase + "/jsp/logout.jsp";
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Logging out with url: " + lUrl));
        }
        GetMethod get = new GetMethod(lUrl);
        try {
            int statusCode = this.client.executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                log4j.error((Object)("Method failed: " + get.getStatusLine()));
                String lContent = get.getResponseBodyAsString();
                log4j.info((Object)("Method body: \n" + lContent));
                return;
            }
        }
        catch (IOException e) {
            String msg = "Error logging in";
            log4j.error((Object)msg, (Throwable)e);
            throw new OperationException(msg, (Throwable)e);
        }
    }

    private void executeVpTask(int pTaskId) throws OperationException {
        this.iTask.execute(pTaskId, null, this.iSession);
    }

    private int createVpTask(Integer pXamTaskId, int pOrgId, int pProjId, int pFrId, int pMedewerkerid, int pNotaId, String pRunDate, String templateType, String facts, String factuurNr) throws OperationException {
        Operation lCreateVpTask = this.iDsFactuur.getOperation("CreateVpTask");
        lCreateVpTask.setParameter("fr_id", (Object)pFrId);
        lCreateVpTask.setParameter("medewerker_id", (Object)pMedewerkerid);
        lCreateVpTask.setParameter(cRunDate, (Object)pRunDate);
        lCreateVpTask.setParameter("trxs", (Object)facts);
        lCreateVpTask.setParameter("template_type", (Object)templateType);
        if (factuurNr != null) {
            lCreateVpTask.setParameter("factuur_nr", (Object)factuurNr);
        }
        ResultSet lRCTask = lCreateVpTask.executeAsResultset();
        Operation lCreateWF = this.iDsFactuur.getOperation("CreateWF");
        Operation lUpdateWF = this.iDsFactuur.getOperation("UpdateWF");
        Operation lUpdateFactuur = this.iDsFactuur.getOperation("UpdateRecord");
        try {
            if (lRCTask.next()) {
                int lWfwId = 0;
                int lDocId = lRCTask.getInt("DOC_ID");
                if (this.iProperties.containsKey((Object)"useWF")) {
                    lCreateWF.setParameter("medewerker_id", (Object)pMedewerkerid);
                    lCreateWF.setParameter("org_id", (Object)pOrgId);
                    lCreateWF.setParameter("proj_id", (Object)pProjId);
                    lCreateWF.setParameter("fr_id", (Object)pFrId);
                    ResultSet lRSCreateWF = lCreateWF.executeAsResultset();
                    lRSCreateWF.next();
                    lWfwId = lRSCreateWF.getInt("P_WFW_ID");
                    lUpdateWF.setParameter("wfw_id", (Object)lWfwId);
                    lUpdateWF.setParameter("doc_id", (Object)lDocId);
                    lUpdateWF.executeAsValueMap();
                }
                lUpdateFactuur.setParameter("task_id", (Object)pXamTaskId);
                lUpdateFactuur.setParameter("nota_id", (Object)pNotaId);
                lUpdateFactuur.setParameter("wfw_id", (Object)lWfwId);
                lUpdateFactuur.setParameter("doc_id", (Object)lDocId);
                lUpdateFactuur.executeAsValueMap();
                return lRCTask.getInt("TASK_ID");
            }
        }
        catch (SQLException e) {
            String message = "Error creating task";
            log4j.error((Object)message, (Throwable)e);
            throw new OperationException(message, (Throwable)e);
        }
        return 0;
    }

    private void skipFactuur(int pXamTaskId, int pNotaId) throws OperationException {
        try {
            Operation lUpdateFactuur = this.iDsFactuur.getOperation("UpdateRecord");
            lUpdateFactuur.setParameter("task_id", (Object)pXamTaskId);
            lUpdateFactuur.setParameter("nota_id", (Object)pNotaId);
            lUpdateFactuur.setParameter("wfw_id", (Object)-1);
            lUpdateFactuur.setParameter("doc_id", (Object)-1);
            lUpdateFactuur.executeAsValueMap();
        }
        catch (OperationException e) {
            String message = "Error skipping factuur";
            log4j.error((Object)message, (Throwable)e);
            throw new OperationException(message, (Throwable)e);
        }
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        ResultSet lResult = this.executeAsResultset();
        log4j.info((Object)("Resultset: " + lResult));
        return null;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "Creates the yeraly account statements";
    }
}

