/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.interest;

import com.ibm.icu.text.SimpleDateFormat;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class MonthylyPremieRevenueOperation
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyPremieRevenueOperation.class);
    private static final String cRunDate = "rundate";
    private static final String cMedewerkerId = "medewerker_id";
    private XamEngine iXE = new XamEngine();
    private Dataset iDsNota = null;
    private Dataset iDsRc = null;
    private Dataset iDsLening = null;
    private Dataset iDataset;
    private Map<String, Object> iParams;
    private Properties iProperties;

    public MonthylyPremieRevenueOperation() throws OperationException {
        try {
            this.iDsNota = this.iXE.getDataset("Nota");
            this.iDsLening = this.iXE.getDataset("Lening");
            this.iDsRc = this.iXE.getDataset("RC");
        }
        catch (DatasetException e) {
            throw new OperationException((Throwable)e);
        }
        this.iParams = new HashMap<String, Object>();
    }

    public boolean canExecute() {
        return true;
    }

    public void close() {
    }

    public ResultSet executeAsResultset() throws OperationException {
        ArrayList<Map<String, Object>> lResult = new ArrayList<Map<String, Object>>();
        log4j.info((Object)("Properties from ds def: " + this.iProperties));
        if (!this.iParams.containsKey(cRunDate) || this.iParams.get(cRunDate) == null) {
            SimpleDateFormat lFmt = new SimpleDateFormat("yyyy-MM-dd");
            this.iParams.put(cRunDate, lFmt.format(new Date()));
            log4j.warn((Object)("parameter bookdate not set, defaulting to: " + this.iParams.get(cRunDate)));
        }
        this.truncateLog();
        this.processLening(lResult);
        Operation lORenteLog = this.iDsNota.getOperation("ListRenteLog");
        return lORenteLog.executeAsResultset();
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        ArrayList<Map<String, Object>> lResultList = new ArrayList<Map<String, Object>>();
        ArrayList<String> lColumnNames = new ArrayList<String>();
        try {
            ResultSet lResult = this.executeAsResultset();
            ResultSetMetaData lMetaData = lResult.getMetaData();
            int lColumnCount = lMetaData.getColumnCount();
            for (int i = 1; i <= lColumnCount; ++i) {
                lColumnNames.add(lMetaData.getColumnName(i));
            }
            while (lResult.next()) {
                HashMap<String, Object> lResultRow = new HashMap<String, Object>();
                for (String lColumnName : lColumnNames) {
                    lResultRow.put(lColumnName, lResult.getObject(lColumnName));
                }
                lResultList.add(lResultRow);
            }
        }
        catch (SQLException e) {
            throw new OperationException((Throwable)e);
        }
        return lResultList;
    }

    private void truncateLog() throws OperationException {
        Operation iOTruncLog = this.iDsNota.getOperation("TruncateRenteLog");
        iOTruncLog.executeAsValueMap();
    }

    public void processLening(List<Map<String, Object>> lResult) throws OperationException {
        PROCESS_LOGGER.start("Leningen", 1);
        Operation lLeningRegels = this.iDsLening.getOperation("ListOpgebouwdePremie");
        lLeningRegels.setParameter("bookdate", this.iParams.get(cRunDate));
        Integer lMedewerker = Integer.parseInt((String)this.iParams.get(cMedewerkerId));
        ResultSet lRentes = lLeningRegels.executeAsResultset();
        try {
            while (lRentes.next()) {
                Double lPremie = lRentes.getDouble("PREMIE");
                Integer lFrId = lRentes.getInt("FR_ID");
                String lPremieCode = this.iProperties.getProperty("LeningPremieCode");
                if (lPremie == null || lPremie == 0.0) continue;
                Operation lFinFact = this.iDsNota.getOperation("CreateFinFact");
                lFinFact.setParameter("code", (Object)lPremieCode);
                lFinFact.setParameter("fr_id", (Object)lFrId);
                lFinFact.setParameter("waarde", (Object)lPremie);
                lFinFact.setParameter("bookdate", this.iParams.get(cRunDate));
                lFinFact.setParameter(cMedewerkerId, (Object)lMedewerker);
                lFinFact.executeAsValueMap();
            }
        }
        catch (SQLException e) {
            String message = "Error processing lening premies";
            log4j.error((Object)message, (Throwable)e);
            throw new OperationException(message, (Throwable)e);
        }
        PROCESS_LOGGER.complete("Leningen", 1);
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    public String getDescription() {
        return "Creates monthly finfacts for interest revenue";
    }

    public Operator getOperator(String pArg0) {
        return null;
    }

    public void setDataset(Dataset pDS) {
        this.iDataset = pDS;
    }

    public void setParameter(String pKey, Object pValue) throws OperationException {
        this.iParams.put(pKey, pValue);
    }

    public void setParameter(String pArg0, List<Object> pArg1) {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public boolean supportsResultset() {
        return true;
    }
}

