/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.kvk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class GetBasisprofielOperation
implements Operation {
    private static Logger log4j = Log4jUtil.createLogger();
    private Map<String, Object> iParams = new HashMap<String, Object>();
    private Dataset iDataset;
    private Properties iProperties;
    private static final String corgkvk = "orgkvk";

    public boolean canExecute() {
        return false;
    }

    public void close() {
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        HashMap<String, List<Object>> final_map = new HashMap<String, List<Object>>();
        String kvk = null;
        try {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"executeAsValueMap() ");
            }
            ArrayList<Object> kvknummers = new ArrayList<Object>();
            ArrayList<Object> vestigingsnummer = new ArrayList<Object>();
            ArrayList<Object> rechtsvorm = new ArrayList<Object>();
            ArrayList<Object> bezoekadres = new ArrayList<Object>();
            ArrayList<Object> bezoekpostcode = new ArrayList<Object>();
            ArrayList<Object> bezoekplaats = new ArrayList<Object>();
            ArrayList<Object> bezoekland = new ArrayList<Object>();
            ArrayList<Object> postadres = new ArrayList<Object>();
            ArrayList<Object> postpostcode = new ArrayList<Object>();
            ArrayList<Object> postplaats = new ArrayList<Object>();
            ArrayList<Object> sbiCode = new ArrayList<Object>();
            ArrayList<Object> sbiCodeHoofd = new ArrayList<Object>();
            ArrayList<Object> sbiOmschrijving = new ArrayList<Object>();
            ArrayList<Object> datumAanvang = new ArrayList<Object>();
            ArrayList<Object> naam = new ArrayList<Object>();
            ArrayList<Object> fte = new ArrayList<Object>();
            ArrayList<Object> staturaireNaam = new ArrayList<Object>();
            ArrayList<Object> formeleregistratiedatum = new ArrayList<Object>();
            ArrayList<Object> website = new ArrayList<Object>();
            ArrayList<Object> rsin = new ArrayList<Object>();
            ArrayList<Object> btw = new ArrayList<Object>();
            ArrayList<Object> handelsnamen = new ArrayList<Object>();
            ArrayList<Object> toevoegingbezoek = new ArrayList<Object>();
            ArrayList<Object> toevoegingpost = new ArrayList<Object>();
            ArrayList<String> organisationJson = new ArrayList<String>();
            Map<Object, Object> map = new HashMap();
            ArrayList list = new ArrayList();
            kvk = this.iParams.get(corgkvk).toString();
            map = this.getOrgDetails(kvk);
            kvknummers.add(map.get("kvkNummer"));
            vestigingsnummer.add(map.get("vestigingsnummer"));
            rechtsvorm.add(map.get("rechtsvorm"));
            bezoekadres.add(map.get("bezoekadres"));
            bezoekpostcode.add(map.get("bezoekpostcode"));
            bezoekplaats.add(map.get("bezoekplaats"));
            bezoekland.add(map.get("bezoekland"));
            postadres.add(map.get("postadres"));
            postpostcode.add(map.get("postpostcode"));
            postplaats.add(map.get("postplaats"));
            sbiCode.add(map.get("sbiCode"));
            sbiCodeHoofd.add(map.get("sbiCodeHoofd"));
            sbiOmschrijving.add(map.get("sbiOmschrijving"));
            datumAanvang.add(map.get("datumAanvang"));
            naam.add(map.get("naam"));
            fte.add(map.get("fte"));
            staturaireNaam.add(map.get("statutaireNaam"));
            formeleregistratiedatum.add(map.get("formeleRegistratiedatum"));
            website.add(map.get("website"));
            rsin.add(map.get("rsin"));
            btw.add(map.get("btw"));
            handelsnamen.add(map.get("handelsnamen"));
            toevoegingbezoek.add(map.get("bezoektoevoeging"));
            toevoegingpost.add(map.get("posttoevoeging"));
            final_map.put("kvknummer", kvknummers);
            final_map.put("vestigingsnummer", vestigingsnummer);
            final_map.put("rechtsvorm", rechtsvorm);
            final_map.put("bezoekadres", bezoekadres);
            final_map.put("bezoekpostcode", bezoekpostcode);
            final_map.put("bezoekplaats", bezoekplaats);
            final_map.put("bezoekland", bezoekland);
            final_map.put("postadres", postadres);
            final_map.put("postpostcode", postpostcode);
            final_map.put("postplaats", postplaats);
            final_map.put("sbiCode", sbiCode);
            final_map.put("sbiCodeHoofd", sbiCodeHoofd);
            final_map.put("sbiOmschrijving", sbiOmschrijving);
            final_map.put("datumAanvang", datumAanvang);
            final_map.put("naam", naam);
            final_map.put("fte", fte);
            final_map.put("statutaireNaam", staturaireNaam);
            final_map.put("formeleRegistratiedatum", formeleregistratiedatum);
            final_map.put("website", website);
            final_map.put("rsin", rsin);
            final_map.put("btw", btw);
            final_map.put("handelsnamen", handelsnamen);
            final_map.put("toevoegingbezoek", toevoegingbezoek);
            final_map.put("toevoegingpost", toevoegingpost);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode organisationJsonNode = objectMapper.createObjectNode();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    organisationJsonNode.putNull(key);
                    continue;
                }
                if (value instanceof String) {
                    organisationJsonNode.put(key, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    organisationJsonNode.put(key, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    organisationJsonNode.put(key, (Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    organisationJsonNode.put(key, (Double)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    organisationJsonNode.put(key, (Boolean)value);
                    continue;
                }
                organisationJsonNode.put(key, value.toString());
            }
            String jsonString = objectMapper.writeValueAsString((Object)organisationJsonNode);
            String base64Json = Base64.getEncoder().encodeToString(jsonString.getBytes(StandardCharsets.UTF_8));
            organisationJson.add(base64Json);
            final_map.put("organisationJson", organisationJson);
        }
        catch (Exception e) {
            log4j.error((Object)"Error fetching data", (Throwable)e);
            throw new OperationException("Error fetching data", (Throwable)e);
        }
        return final_map;
    }

    public Map<String, Object> getOrgDetails(String kvknummer) throws OperationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String token = ConfigurationProperties.get().get("kvk.Key").toString();
        String url_string = ConfigurationProperties.get().get("kvk.Basisprofielurl").toString();
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Dynamics.key = " + token));
            log4j.debug((Object)("Dynamics.Addurl = " + url_string));
        }
        try {
            JsonNode handelsnaamObj;
            int i;
            ArrayNode handelsnamenArray;
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"getOrgDetails() called");
            }
            URL url = new URL(url_string + kvknummer);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("url called = " + url));
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Cache-Control", "no-cache");
            con.setRequestProperty("User-Agent", "PostmanRuntime/7.26.2");
            con.setRequestProperty("Accept", "*/*");
            con.setRequestProperty("Connection", "keep-alive");
            con.setRequestProperty("Content-Type", "json");
            con.setRequestProperty("apikey", token);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(con.getInputStream());
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Resultaat: " + root));
            }
            JsonNode embedded = root.get("_embedded");
            JsonNode hoofdvestiging = embedded.get("hoofdvestiging");
            JsonNode eigenaar = embedded.get("eigenaar");
            JsonNode service_answer_adressen = null;
            if (hoofdvestiging != null) {
                service_answer_adressen = hoofdvestiging.get("adressen");
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("service_answer_adressen van hoofdvestiging: " + service_answer_adressen));
                }
            } else if (eigenaar != null) {
                service_answer_adressen = eigenaar.get("adressen");
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("service_answer_adressen van eigenaar: " + service_answer_adressen));
                }
            }
            if (service_answer_adressen != null) {
                for (JsonNode adres : service_answer_adressen) {
                    String adresStr;
                    String type_adres = adres.get("type").asText();
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("type_adres: " + (String)type_adres));
                    }
                    if (type_adres.equals("bezoekadres")) {
                        adresStr = adres.get("straatnaam").asText() + " " + adres.get("huisnummer");
                        if (adres.has("huisletter") && !adres.get("huisletter").asText().isEmpty()) {
                            adresStr = adresStr + adres.get("huisletter").asText();
                        }
                        map.put("bezoekadres", adresStr);
                        map.put("bezoekpostcode", adres.get("postcode").asText());
                        map.put("bezoekplaats", adres.get("plaats").asText());
                        map.put("bezoekland", adres.get("land").asText());
                        if (!adres.has("toevoegingAdres")) continue;
                        map.put("bezoektoevoeging", adres.get("toevoegingAdres").asText());
                        continue;
                    }
                    if (!type_adres.equalsIgnoreCase("Correspondentieadres")) continue;
                    adresStr = "";
                    if (adres.has("postbusnummer")) {
                        adresStr = "Postbus " + adres.get("postbusnummer").asText();
                    } else if (adres.has("straatHuisnummer")) {
                        adresStr = adres.get("straatHuisnummer").asText();
                    } else {
                        JsonNode toevoeging;
                        adresStr = adres.get("straatnaam").asText() + " " + adres.get("huisnummer");
                        if (adres.has("huisletter") && !adres.get("huisletter").asText().isEmpty()) {
                            adresStr = adresStr + " " + adres.get("huisletter").asText();
                        }
                        if ((toevoeging = adres.get("toevoegingAdres")) != null && !toevoeging.asText().isEmpty()) {
                            map.put("posttoevoeging", toevoeging.asText());
                        }
                    }
                    map.put("postadres", adresStr);
                    if (adres.has("postcode")) {
                        map.put("postpostcode", adres.get("postcode").asText());
                    }
                    if (adres.has("postcodeWoonplaats")) {
                        String plaats = adres.get("postcodeWoonplaats").asText();
                        if (adres.has("land")) {
                            plaats = plaats + " " + adres.get("land").asText();
                        }
                        map.put("postplaats", plaats);
                        continue;
                    }
                    map.put("postplaats", adres.get("plaats").asText());
                }
            }
            JsonNode hoofdactiviteit = root.get("sbiActiviteiten");
            String sbiCodes = "";
            for (JsonNode act : hoofdactiviteit) {
                String type_sbi = act.get("indHoofdactiviteit").asText();
                sbiCodes = sbiCodes + (sbiCodes.length() == 0 ? "" : ", ") + act.get("sbiCode").asText();
                if (!type_sbi.equals("Ja")) continue;
                map.put("sbiOmschrijving", act.get("sbiOmschrijving").asText());
                map.put("sbiCodeHoofd", act.get("sbiCode").asText());
            }
            map.put("sbiCode", sbiCodes);
            JsonNode registratie = root.get("materieleRegistratie");
            if (registratie != null) {
                String aanvang = GetBasisprofielOperation.getYearFromIsoDate(registratie.get("datumAanvang"));
                map.put("datumAanvang", aanvang);
            }
            if (hoofdvestiging != null && hoofdvestiging.has("vestigingsnummer")) {
                map.put("vestigingsnummer", hoofdvestiging.get("vestigingsnummer").asText());
            }
            if (eigenaar != null && eigenaar.has("rechtsvorm")) {
                map.put("rechtsvorm", eigenaar.get("rechtsvorm").asText());
            }
            if (eigenaar != null && eigenaar.has("rsin")) {
                map.put("rsin", eigenaar.get("rsin").asText());
            }
            if (eigenaar != null && eigenaar.has("btw")) {
                map.put("btw", eigenaar.get("btw").asText());
            }
            map.put("naam", root.get("naam").asText());
            if (root.has("totaalWerkzamePersonen")) {
                map.put("fte", root.get("totaalWerkzamePersonen"));
            }
            map.put("kvkNummer", root.get("kvkNummer").asText());
            if (root.has("statutaireNaam")) {
                map.put("statutaireNaam", root.get("statutaireNaam").asText());
            }
            if (root.get("formeleRegistratiedatum") != null) {
                map.put("formeleRegistratiedatum", GetBasisprofielOperation.convertFromIsoDate(root.get("formeleRegistratiedatum")));
            } else if (registratie != null) {
                map.put("formeleRegistratiedatum", GetBasisprofielOperation.convertFromIsoDate(registratie.get("datumAanvang")));
            }
            StringBuilder handelsnamenBuilder = new StringBuilder();
            if (root.has("handelsnamen") && root.get("handelsnamen").isArray()) {
                handelsnamenArray = (ArrayNode)root.get("handelsnamen");
                for (i = 0; i < handelsnamenArray.size(); ++i) {
                    handelsnaamObj = handelsnamenArray.get(i);
                    if (!handelsnaamObj.has("naam")) continue;
                    if (i > 0) {
                        handelsnamenBuilder.append(", ");
                    }
                    handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
                }
            }
            if (handelsnamenBuilder.length() == 0 && hoofdvestiging != null && hoofdvestiging.has("handelsnamen") && hoofdvestiging.get("handelsnamen").isArray()) {
                handelsnamenArray = (ArrayNode)hoofdvestiging.get("handelsnamen");
                for (i = 0; i < handelsnamenArray.size(); ++i) {
                    handelsnaamObj = handelsnamenArray.get(i);
                    if (!handelsnaamObj.has("naam")) continue;
                    if (i > 0) {
                        handelsnamenBuilder.append(", ");
                    }
                    handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
                }
            }
            if (handelsnamenBuilder.length() == 0 && eigenaar != null && eigenaar.has("handelsnamen") && eigenaar.get("handelsnamen").isArray()) {
                handelsnamenArray = (ArrayNode)eigenaar.get("handelsnamen");
                for (i = 0; i < handelsnamenArray.size(); ++i) {
                    handelsnaamObj = handelsnamenArray.get(i);
                    if (!handelsnaamObj.has("naam")) continue;
                    if (i > 0) {
                        handelsnamenBuilder.append(", ");
                    }
                    handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
                }
            }
            if (handelsnamenBuilder.length() > 0) {
                map.put("handelsnamen", handelsnamenBuilder.toString());
            }
            if (hoofdvestiging != null && hoofdvestiging.has("websites") && hoofdvestiging.get("websites").isArray() && hoofdvestiging.get("websites").get(0) != null) {
                map.put("website", hoofdvestiging.get("websites").get(0).asText());
            }
        }
        catch (Exception e) {
            log4j.error((Object)"Error fetching data", (Throwable)e);
            throw new OperationException("Error fetching data", (Throwable)e);
        }
        return map;
    }

    static String convertFromIsoDate(JsonNode pDate) {
        if (pDate == null) {
            return "";
        }
        String val = pDate.asText();
        if (val.contains("T")) {
            LocalDateTime date = LocalDateTime.parse(val);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
            return date.format(formatter);
        }
        LocalDate date = LocalDate.parse(val, DateTimeFormatter.BASIC_ISO_DATE);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        return date.format(formatter);
    }

    static String getYearFromIsoDate(JsonNode pDate) {
        if (pDate == null) {
            return "";
        }
        String val = pDate.asText();
        if (val.contains("T")) {
            LocalDateTime date = LocalDateTime.parse(val);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
            return date.format(formatter);
        }
        LocalDate date = LocalDate.parse(val, DateTimeFormatter.BASIC_ISO_DATE);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
        return date.format(formatter);
    }

    public String getDescription() {
        return "Get info from basisprofiel list from search";
    }

    public Operator getOperator(String arg0) {
        return null;
    }

    public void setDataset(Dataset pDS) {
        this.iDataset = pDS;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String arg0, List<Object> arg1) {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public boolean supportsResultset() {
        return false;
    }
}

