/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.onboarding.operation;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.oostnl.ventureplan.jobs.onboarding.adapter.QueueDao;
import nl.oostnl.ventureplan.jobs.onboarding.domain.AanvraagQueueItem;
import nl.oostnl.ventureplan.jobs.onboarding.domain.ProcessingResult;
import nl.oostnl.ventureplan.jobs.onboarding.service.ItemProcessor;
import org.apache.log4j.Logger;

public class ProcessQueueOperation
implements Operation {
    private static Logger log4j = Log4jUtil.createLogger();
    private Map<String, Object> params = new HashMap<String, Object>();
    private Properties properties;

    public boolean canExecute() {
        return true;
    }

    public void close() {
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        int limit = this.parseInt(this.params.get("limit"), 10);
        long start = System.currentTimeMillis();
        log4j.info((Object)("Processing queue with limit " + limit));
        QueueDao dao = new QueueDao(this.properties);
        List<AanvraagQueueItem> items = dao.fetchNextBatch(limit);
        long claimed = items == null ? 0L : (long)items.size();
        long completed = 0L;
        long rejected = 0L;
        ItemProcessor processor = new ItemProcessor(this.properties);
        if (items != null) {
            for (AanvraagQueueItem it : items) {
                log4j.info((Object)"========================================================================================");
                log4j.info((Object)("Processing item " + it));
                ProcessingResult res = processor.process(it);
                log4j.info((Object)("Processing result " + res));
                if (res != null && res.getStatus() == ProcessingResult.Status.SUCCESS) {
                    log4j.info((Object)("Marking completed " + it.getQueueId()));
                    dao.markCompleted(it.getQueueId());
                    ++completed;
                    continue;
                }
                log4j.info((Object)("Marking rejected " + it.getQueueId()));
                String errCode = res == null ? null : res.getErrorCode();
                String errMsg = res == null ? null : res.getErrorMessage();
                dao.markRejected(it.getQueueId(), errCode, errMsg);
                ++rejected;
            }
        }
        long duration = System.currentTimeMillis() - start;
        log4j.info((Object)"========================================================================================");
        HashMap<String, Long> row = new HashMap<String, Long>();
        row.put("claimed", claimed);
        row.put("completed", completed);
        row.put("rejected", rejected);
        row.put("duration_ms", duration);
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        out.add(row);
        log4j.info((Object)("Result " + row));
        log4j.info((Object)"========================================================================================");
        return out;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return new HashMap<String, List<Object>>();
    }

    private int parseInt(Object o, int def) {
        if (o == null) {
            return def;
        }
        try {
            return Integer.parseInt(String.valueOf(o));
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getDescription() {
        return "Process onboarding queue";
    }

    public Operator getOperator(String arg0) {
        return null;
    }

    public void setDataset(Dataset pDS) {
    }

    public void setParameter(String name, Object value) throws OperationException {
        this.params.put(name, value);
    }

    public void setParameter(String name, List<Object> values) {
    }

    public void setProperties(Properties pProperties) {
        this.properties = pProperties;
    }

    public boolean supportsResultset() {
        return false;
    }
}

