/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.onboarding.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.oostnl.ventureplan.jobs.onboarding.domain.AanvraagQueueItem;
import nl.oostnl.ventureplan.jobs.onboarding.domain.IntakeData;
import nl.oostnl.ventureplan.jobs.onboarding.domain.ProcessingResult;
import org.apache.log4j.Logger;

public class ItemProcessor {
    private static Logger log4j = Log4jUtil.createLogger();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern EMAIL_REGEX = Pattern.compile("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$");
    private final Properties properties;

    public ItemProcessor(Properties properties) {
        this.properties = properties;
    }

    private ProcessingResult validateEmailOrReject(AanvraagQueueItem item, IntakeData intake) {
        String email;
        String string = email = intake == null ? null : intake.getEmail();
        if (email == null || email.trim().isEmpty()) {
            log4j.warn((Object)("Validation failed: EMAIL_REQUIRED for queue_id=" + (item == null ? null : Long.valueOf(item.getQueueId()))));
            return new ProcessingResult(ProcessingResult.Status.REJECTED, "EMAIL_REQUIRED", "E-mail is verplicht", 0L);
        }
        if (!EMAIL_REGEX.matcher(email).matches()) {
            log4j.warn((Object)("Validation failed: EMAIL_INVALID for queue_id=" + (item == null ? null : Long.valueOf(item.getQueueId())) + ", email=" + email));
            return new ProcessingResult(ProcessingResult.Status.REJECTED, "EMAIL_INVALID", "E-mail formaat ongeldig", 0L);
        }
        if (this.userExistsByEmail(email)) {
            log4j.info((Object)("Validation failed: EMAIL_EXISTS for queue_id=" + (item == null ? null : Long.valueOf(item.getQueueId())) + ", email=" + email));
            return new ProcessingResult(ProcessingResult.Status.REJECTED, "EMAIL_EXISTS", "E-mailadres is al in gebruik als loginnaam", 0L);
        }
        return null;
    }

    public ProcessingResult process(AanvraagQueueItem item) {
        ProcessingResult emailValidation;
        if (log4j.isInfoEnabled() && item != null) {
            log4j.info((Object)("Start processing queue_id=" + item.getQueueId() + ", aanvraag_type_id=" + item.getAanvraagTypeId() + ", email=" + item.getRequesterEmail()));
        }
        JsonNode payload = this.parseJsonNode(item == null ? null : item.getPayloadJson());
        if (item != null && item.getPayloadJson() != null && payload == null) {
            log4j.warn((Object)("Invalid JSON payload for queue_id=" + (item == null ? null : Long.valueOf(item.getQueueId()))));
            try {
                this.updateQueueStatus(item, "rejected", "INVALID_JSON", "Payload kon niet worden geparsed");
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return new ProcessingResult(ProcessingResult.Status.REJECTED, "INVALID_JSON", "Payload kon niet worden geparsed", 0L);
        }
        IntakeData intake = this.buildIntakeData(item, payload);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("IntakeData: " + intake));
        }
        if ((emailValidation = this.validateEmailOrReject(item, intake)) != null) {
            try {
                this.updateQueueStatus(item, "rejected", emailValidation.getErrorCode(), emailValidation.getErrorMessage());
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return emailValidation;
        }
        String kvk = intake.getKvk().orElse(null);
        if (kvk != null && !kvk.isEmpty() && !kvk.matches("^[0-9]{8}$")) {
            log4j.warn((Object)("Validation failed: INVALID_KVK for queue_id=" + (item == null ? null : Long.valueOf(item.getQueueId())) + ", kvk=" + kvk));
            try {
                this.updateQueueStatus(item, "rejected", "INVALID_KVK", "KvK moet 8 cijfers bevatten");
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return new ProcessingResult(ProcessingResult.Status.REJECTED, "INVALID_KVK", "KvK moet 8 cijfers bevatten", 0L);
        }
        if (log4j.isInfoEnabled() && item != null) {
            log4j.info((Object)("Validations passed for queue_id=" + item.getQueueId()));
        }
        try {
            XamEngine xe = new XamEngine();
            Dataset ds = xe.getDataset("Klantportaal");
            Operation op = ds.getOperation("ProcessQueueItem");
            op.setProperties(this.properties);
            op.setParameter("queue_id", (Object)item.getQueueId());
            Map vm = op.executeAsValueMap();
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)("Aanvraag verwerkt voor queue_id=" + item.getQueueId() + ", resultKeys=" + (vm == null ? null : vm.keySet())));
            }
            try {
                this.updateQueueStatus(item, "completed", null, null);
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return new ProcessingResult(ProcessingResult.Status.SUCCESS, null, null, 0L);
        }
        catch (OperationException e) {
            String code = this.extractErrorCode(e == null ? null : e.getMessage());
            log4j.error((Object)"Aanvraagverwerking fout (operation)", (Throwable)e);
            try {
                this.updateQueueStatus(item, "error", code == null ? "PROCESS_FAILED" : code, e.getMessage());
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return new ProcessingResult(ProcessingResult.Status.ERROR, code == null ? "PROCESS_FAILED" : code, e.getMessage(), 0L);
        }
        catch (DatasetException e) {
            String code = this.extractErrorCode(e == null ? null : e.getMessage());
            log4j.error((Object)"Aanvraagverwerking fout (dataset)", (Throwable)e);
            try {
                this.updateQueueStatus(item, "error", code == null ? "PROCESS_FAILED" : code, e.getMessage());
            }
            catch (Exception ex) {
                log4j.error((Object)"Status update failed", (Throwable)ex);
            }
            return new ProcessingResult(ProcessingResult.Status.ERROR, code == null ? "PROCESS_FAILED" : code, e.getMessage(), 0L);
        }
    }

    private JsonNode parseJsonNode(String json) {
        if (json == null) {
            return null;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (Exception e) {
            log4j.error((Object)"Payload kon niet worden geparsed", (Throwable)e);
            return null;
        }
    }

    private IntakeData buildIntakeData(AanvraagQueueItem item, JsonNode payload) {
        String email = item == null ? null : item.getRequesterEmail();
        String kvk = item == null ? null : item.getRequesterKvk();
        Map<String, String> answers = this.payloadToMap(payload);
        return new IntakeData(email, Optional.ofNullable(kvk), answers);
    }

    private Map<String, String> payloadToMap(JsonNode node) {
        HashMap<String, String> out = new HashMap<String, String>();
        if (node == null || !node.isObject()) {
            return out;
        }
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            JsonNode v = (JsonNode)e.getValue();
            String val = v == null || v.isNull() ? null : v.asText();
            out.put((String)e.getKey(), val);
        }
        return out;
    }

    private boolean userExistsByEmail(String email) {
        try {
            XamEngine xe = new XamEngine();
            Dataset ds = xe.getDataset("Admin");
            Operation op = ds.getOperation("UserExistsByName");
            op.setProperties(this.properties);
            op.setParameter("ug_name", (Object)email);
            Map vm = op.executeAsValueMap();
            if (vm == null || !vm.containsKey("exists") || ((List)vm.get("exists")).isEmpty()) {
                return false;
            }
            Object val = ((List)vm.get("exists")).get(0);
            String s = val == null ? null : String.valueOf(val);
            return "true".equalsIgnoreCase(s);
        }
        catch (DatasetException | OperationException e) {
            log4j.error((Object)"Kon user-exists check niet uitvoeren", e);
            return false;
        }
    }

    private void updateQueueStatus(AanvraagQueueItem item, String status, String errorCode, String errorDetails) throws OperationException, DatasetException {
        if (item == null) {
            return;
        }
        XamEngine xe = new XamEngine();
        Dataset ds = xe.getDataset("Aanvraag");
        Operation op = ds.getOperation("QueueStatusUpdate");
        op.setProperties(this.properties);
        op.setParameter("queue_id", (Object)item.getQueueId());
        op.setParameter("status", (Object)status);
        if (errorCode != null) {
            op.setParameter("error_code", (Object)errorCode);
        }
        if (errorDetails != null) {
            op.setParameter("error_details", (Object)errorDetails);
        }
        op.executeAsValueMap();
    }

    private String extractErrorCode(String message) {
        String head;
        if (message == null) {
            return null;
        }
        String m = message.trim();
        int sp = m.indexOf(32);
        String string = head = sp > 0 ? m.substring(0, sp) : m;
        if (head.matches("[A-Z0-9_]+")) {
            return head;
        }
        return null;
    }
}

