/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.organisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class SearchOrganisationOperation
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.10 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private Map<String, Object> iParams = new HashMap<String, Object>();
    private Dataset iDataset;
    private Properties iProperties;
    private static final String corgname = "orgname";
    private static final String corgkvk = "orgkvk";
    private static final String corgcity = "orgcity";

    public boolean canExecute() {
        return true;
    }

    public void close() {
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        String token = ConfigurationProperties.get().get("Dynamics.Key").toString();
        String url_string = ConfigurationProperties.get().get("Dynamics.Searchurl").toString();
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Dynamics.key = " + token));
            log4j.debug((Object)("Dynamics.Addurl = " + url_string));
        }
        String org_name = this.iParams.get(corgname).toString();
        String kvk_id = this.iParams.get(corgkvk).toString();
        String org_city = this.iParams.get(corgcity).toString();
        URL url = null;
        try {
            url = new URL(url_string);
        }
        catch (MalformedURLException e) {
            log4j.error((Object)"Invallid Searchurl", (Throwable)e);
            throw new OperationException("Invallid Searchurl", (Throwable)e);
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e1) {
            log4j.error((Object)("Could not open url: " + url), (Throwable)e1);
            throw new OperationException("Could not open url: " + url, (Throwable)e1);
        }
        try {
            con.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            log4j.error((Object)"Error during POST", (Throwable)e);
            throw new OperationException("Error during POST", (Throwable)e);
        }
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + token);
        con.setDoOutput(true);
        JSONObject jo = new JSONObject();
        jo.put((Object)"Name", (Object)org_name);
        jo.put((Object)"KvK", (Object)kvk_id);
        jo.put((Object)"City", (Object)org_city);
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jo.toString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        catch (IOException e) {
            log4j.error((Object)"Error fetching data", (Throwable)e);
            throw new OperationException("Error fetching data", (Throwable)e);
        }
        Object service_answer2 = null;
        Object service_answer = null;
        JSONArray service_answer_array = null;
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        try {
            InputStreamReader service_stream = new InputStreamReader(con.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String objectfromapi = br.readLine();
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("JSON returned from service: " + objectfromapi));
            }
            try {
                service_answer_array = JSONArray.fromObject((Object)objectfromapi);
            }
            catch (JSONException e) {
                log4j.error((Object)"Could not parse JSON from service", (Throwable)e);
                throw new OperationException("Could not parse JSON from service", (Throwable)e);
            }
            for (int i = 0; i < service_answer_array.size(); ++i) {
                String jsonstring = service_stream.toString();
                Iterator it = service_answer_array.getJSONObject(i).keySet().iterator();
                while (it.hasNext()) {
                    ArrayList list;
                    String key = it.next().toString();
                    JSONObject object = service_answer_array.getJSONObject(i);
                    String value = service_answer_array.getJSONObject(i).get(key).toString();
                    if (value == "null") {
                        value = "";
                    }
                    if (map.containsKey(key)) {
                        list = (ArrayList)map.get(key);
                        list.add(value);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(value);
                    map.put(key, list);
                }
            }
        }
        catch (IOException e) {
            log4j.error((Object)"Error processing data", (Throwable)e);
            throw new OperationException("Error processing data", (Throwable)e);
        }
        return map;
    }

    public String getDescription() {
        return "Get info from specific device";
    }

    public Operator getOperator(String arg0) {
        return null;
    }

    public void setDataset(Dataset pDS) {
        this.iDataset = pDS;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String arg0, List<Object> arg1) {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public boolean supportsResultset() {
        return false;
    }
}

