package nl.buildersenperformers.cheyenne.configtest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.sql.JdbcBase;
import nl.knowledgeplaza.util.ConfigurationProperties;

public class DbTests extends JdbcBase {
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
	
	public DbTests(){
		super();
	}
	
	/**
	 * Test the connection
	 */
	public int testConnection(){
		int errorCount=0;
		errorCount += testPool("defaultJdbcConnectionName");
		errorCount += testPool("xam.jdbcPoolName");
		errorCount += testPool("Daemon.connectionPool");
		return errorCount;
	}

	public int testPool(String poolNameProp) {
		int errorCount=0;
		String poolName=ConfigurationProperties.get().get(poolNameProp);
		if (poolName == null){
			log4j.warn(poolNameProp + " does not exist in configuration.properties");
			return errorCount;
		}
		
		log4j.info("initializing pool: configuration.properties: " + poolNameProp + "=" + poolName);
		initPool(poolName);
		
		log4j.info("testing connection");
		Connection conn = getConnection();
		if (conn != null){
			log4j.info("connection ok");
			
			log4j.info("Test query: select 1");
			String query = "select 1";
			try {
				PreparedStatement stmt = conn.prepareStatement(query);
				stmt.executeQuery();
				log4j.info("query ok");
			} catch (SQLException e) {
				log4j.error("query failed",e);
				errorCount++;
			} finally{
				returnConnection(conn);
				log4j.info("connection closed");
			}
			
		} else {
			log4j.error("connection is null!");
			errorCount++;
		}
		return errorCount;
	}
}
