package nl.buildersenperformers.cheyenne.configtest;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;

import nl.knowledgeplaza.util.ConfigurationProperties;

public class DocstoreTest {
	Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
	
	public int test() {
		int errorCount=0;
		String docstoreUrl = ConfigurationProperties.get().get("DocstoreFilter.baseurl");
		if(docstoreUrl==null){
			return errorCount;
		}
		if (docstoreUrl == null) {
			log4j.warn("DocstoreFilter.baseurl is null, skipping test");
			return errorCount;
		}
		log4j.info("DocstoreFilter.baseurl: " + docstoreUrl);
		URL url = null;
		try {
			url = new URL(docstoreUrl);
		} catch (MalformedURLException e) {
			log4j.error("DocstoreFilter.baseurl is malformed", e);
			errorCount++;
			return errorCount;
		}
		
		//test url response, only http response 200 and 401 are allowed
		try {
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			if (conn.getResponseCode() != 200 && conn.getResponseCode() != 401) {
				errorCount++;
				//get error reponse
				String error = conn.getResponseMessage();
				
				log4j.error("Connection failed: response code: " + conn.getResponseCode() + (error != null ? " " + error : ""));
				return errorCount;
			}
			
			log4j.info("DocstoreFilter.baseurl response code: " + conn.getResponseCode() + ", 200 or 401 is ok");
			conn.disconnect();
			
		} catch (IOException e) {
			log4j.error("DocstoreFilter.baseurl connection failed", e);
			errorCount++;
		}
		return errorCount;
	}

}
