/**
 * 
 */
package nl.buildersenperformers.cheyenne.dialog.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;

/**
 * @author stpl
 * Implements the dataset for extenden Cheyenne Dialog capabilities
 */
public class DialogUitlDataset implements Dataset {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(DialogUitlDataset.class);

	private Properties iProperties=null;

	@Override
	public Operation getCreate() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Operation getRead() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Operation getUpdate() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Operation getDelete() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Operation getList() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> listOperations() {
		List<String> lRetVal=new ArrayList<>();
		lRetVal.add("RequestString");
		lRetVal.add("RequestParamsJson");
		return lRetVal;
	}

	@Override
	public Operation getOperation(String pOperation) throws OperationException {
		Operation lRet=null;
		switch (pOperation) {
			case "RequestString": lRet=new RequestStringOperation();lRet.setProperties(iProperties);break;
			case "RequestParamsJson": lRet=new RequestParamsJsonOperation(); lRet.setProperties(iProperties); break;
		}
		return lRet;
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;
	}

	@Override
	public String getDescription() {
		return "DialogUitlDataset";
	}

	@Override
	public String getDocumentation() {
		ClassLoader classLoader = getClass().getClassLoader();
		InputStream lDocStream=classLoader.getResourceAsStream("finfact/documentation.md");
		try {
			return IOUtil.toString(lDocStream);
		} catch (IOException e) {
			log4j.error("Could not get documentation",e);
		}
		return null;
	}

}
