package nl.buildersenperformers.cheyenne.dialog.dataset;

import java.sql.ResultSet;
import java.util.*;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DialogOperation;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.CheyenneServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.knowledgeplaza.util.Properties;

/**
 * Builds a JSON string from the current HTTP request parameters.
 * Optional parameters (set via setParameter):
 * - includeRemoteIp: boolean, default true
 * - whitelist: comma-separated names; if set, only these parameters are included
 * - blacklist: comma-separated names; these parameters are excluded (overrides whitelist)
 * - flattenSingleValue: boolean, default true (multi-values remain arrays)
 * The resulting JSON string is returned under key "json" (or "<id>_json" if id is set).
 */
public class RequestParamsJsonOperation implements Operation, DialogOperation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.0 $";

    private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(RequestParamsJsonOperation.class);

    private Dialog iDialog = null;
    private Dataset iDataset;
    private Map<String, Object> iParams = new HashMap<>();
    private Properties iProperties;
    private String iId;

    private boolean includeRemoteIp = true;
    private boolean flattenSingleValue = true;
    private final Set<String> whitelist = new HashSet<>();
    private final Set<String> blacklist = new HashSet<>(
        Arrays.asList("secret","parmeter_value","password","token","refresh_token")
    );

    @Override
    public void setDialog(Dialog pDialog) {
        iDialog = pDialog;
    }

    @Override
    public Dialog getDialog() {
        return iDialog;
    }

    @Override
    public Operator getOperator(String pName) {
        return null;
    }

    @Override
    public void setParameter(String pName, Object pValue) throws OperationException {
        if (pValue == null) return;
        String v = String.valueOf(pValue);
        switch (pName) {
            case "id":
                // Allow setting the operation id via parameter so dataset attribute id controls output key
                setId(v);
                return;
            case "includeRemoteIp":
                includeRemoteIp = "true".equalsIgnoreCase(v);
                return;
            case "flattenSingleValue":
                flattenSingleValue = "true".equalsIgnoreCase(v);
                return;
            case "whitelist": {
                whitelist.clear();
                for (String s : v.split(",")) {
                    if (StringUtils.isNotBlank(s)) whitelist.add(s.trim());
                }
                return;
            }
            case "blacklist": {
                for (String s : v.split(",")) {
                    if (StringUtils.isNotBlank(s)) blacklist.add(s.trim());
                }
                return;
            }
            default:
                iParams.put(pName, pValue);
        }
    }

    @Override
    public void setParameter(String pName, List<Object> pValue) { /* not used */ }

    @Override
    public boolean canExecute() { return true; }

    @Override
    public boolean supportsResultset() { return false; }

    @Override
    public ResultSet executeAsResultset() { return null; }

    @Override
    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        Map<String, List<Object>> result = new HashMap<>();
        if (iDialog == null) return result;

        Context chyContext = (Context) iDialog.getContext();
        CheyenneServletContext context = new CheyenneServletContext(chyContext);
        JSONObject root = new JSONObject();

        if (context != null && context.getRequest() != null) {
            Enumeration<String> names = context.getRequest().getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if (!whitelist.isEmpty() && !whitelist.contains(name)) continue;
                if (blacklist.contains(name)) continue;

                String[] values = context.getRequest().getParameterValues(name);
                if (values == null) continue;

                if (values.length == 1 && flattenSingleValue) {
                    root.put(name, values[0]);
                } else {
                    JSONArray arr = new JSONArray();
                    for (String val : values) arr.add(val);
                    root.put(name, arr);
                }
            }

            if (includeRemoteIp) {
                String ip = context.getRequest().getHeader("X-FORWARDED-FOR");
                if (ip == null || ip.isEmpty()) ip = context.getRequest().getRemoteAddr();
                root.put("remote_ip", ip);
            }
        }

        String fieldName = "json";
        if (getId() != null) fieldName = getId() + "_" + fieldName;
        List<Object> fieldVal = new ArrayList<>();
        fieldVal.add(root.toString());
        result.put(fieldName, fieldVal);
        return result;
    }

    @Override
    public List<Map<String, Object>> executeAsValueList() { return null; }

    @Override
    public void close() { /* nothing */ }

    @Override
    public void setProperties(Properties pProperties) { iProperties = pProperties; }

    @Override
    public void setDataset(Dataset pDataset) { iDataset = pDataset; }

    @Override
    public String getDescription() { return "RequestParamsJson"; }

    @Override
    public void setId(String pId) { iId = pId; }

    @Override
    public String getId() { return iId; }
}
