/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.configtest;

import java.io.File;
import nl.buildersenperformers.cheyenne.configtest.DbTests;
import nl.buildersenperformers.cheyenne.configtest.DocstoreTest;
import nl.buildersenperformers.cheyenne.configtest.FileLocations;
import nl.buildersenperformers.cheyenne.configtest.HttpsTest;
import nl.buildersenperformers.cheyenne.configtest.Log4jCounter;
import nl.buildersenperformers.cheyenne.configtest.SecurityFilterTest;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.HierarchyEventListener;

public class ConfigTest {
    private static Logger log4j = Log4jUtil.createLogger();

    public static void main(String[] args) {
        log4j.getLoggerRepository().addHierarchyEventListener((HierarchyEventListener)new Log4jCounter());
        if (args.length != 2) {
            System.out.println("Usage: ConfigTest <path to config> <path to webapp root");
            return;
        }
        String lSettings = args[0];
        File lConfigFile = new File(lSettings);
        if (!lConfigFile.exists()) {
            log4j.error((Object)("Config file " + lSettings + " does not exists"));
            return;
        }
        log4j.info((Object)("Config file: " + lSettings));
        String lWebappRoot = args[1];
        File lWebappRootFile = new File(lWebappRoot);
        if (!lWebappRootFile.exists()) {
            log4j.error((Object)("Webapp root " + lWebappRoot + " does not exists"));
            return;
        }
        log4j.info((Object)("Webapp root: " + lWebappRoot));
        File[] lConfigFiles = new File[]{lConfigFile};
        ConfigurationProperties lConfig = new ConfigurationProperties(lConfigFiles);
        ConfigurationProperties.set((ConfigurationProperties)lConfig);
        int errorCount = 0;
        log4j.info((Object)"------------------------ Testing database connection ------------------------");
        errorCount += new DbTests().testConnection();
        log4j.info((Object)"------------------------ Testing file locations ------------------------");
        errorCount += new FileLocations().test(lWebappRoot);
        log4j.info((Object)"------------------------ Testing docstore ------------------------");
        errorCount += new DocstoreTest().test();
        log4j.info((Object)"------------------------ Testing security filter ------------------------");
        errorCount += new SecurityFilterTest().test(lWebappRoot);
        log4j.info((Object)"------------------------ Testing https connections ------------------------");
        log4j.info((Object)"------------------------ Testing finished ------------------------");
        log4j.info((Object)("Number of errors: " + (errorCount += new HttpsTest().test())));
    }
}

