/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.configtest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import nl.buildersenperformers.xam.engine.sql.JdbcBase;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class DbTests
extends JdbcBase {
    private static Logger log4j = Log4jUtil.createLogger();

    public int testConnection() {
        int errorCount = 0;
        errorCount += this.testPool("defaultJdbcConnectionName");
        errorCount += this.testPool("xam.jdbcPoolName");
        return errorCount += this.testPool("Daemon.connectionPool");
    }

    public int testPool(String poolNameProp) {
        int errorCount = 0;
        String poolName = ConfigurationProperties.get().get(poolNameProp);
        if (poolName == null) {
            log4j.warn((Object)(String.valueOf(poolNameProp) + " does not exist in configuration.properties"));
            return errorCount;
        }
        log4j.info((Object)("initializing pool: configuration.properties: " + poolNameProp + "=" + poolName));
        this.initPool(poolName);
        log4j.info((Object)"testing connection");
        Connection conn = this.getConnection();
        if (conn != null) {
            log4j.info((Object)"connection ok");
            log4j.info((Object)"Test query: select 1");
            String query = "select 1";
            try {
                try {
                    PreparedStatement stmt = conn.prepareStatement(query);
                    stmt.executeQuery();
                    log4j.info((Object)"query ok");
                }
                catch (SQLException e) {
                    log4j.error((Object)"query failed", (Throwable)e);
                    ++errorCount;
                    this.returnConnection(conn);
                    log4j.info((Object)"connection closed");
                }
            }
            finally {
                this.returnConnection(conn);
                log4j.info((Object)"connection closed");
            }
        } else {
            log4j.error((Object)"connection is null!");
            ++errorCount;
        }
        return errorCount;
    }
}

