/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.configtest;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class DocstoreTest {
    Logger log4j = Log4jUtil.createLogger();

    public int test() {
        int errorCount = 0;
        String docstoreUrl = ConfigurationProperties.get().get("DocstoreFilter.baseurl");
        if (docstoreUrl == null) {
            return errorCount;
        }
        if (docstoreUrl == null) {
            this.log4j.warn((Object)"DocstoreFilter.baseurl is null, skipping test");
            return errorCount;
        }
        this.log4j.info((Object)("DocstoreFilter.baseurl: " + docstoreUrl));
        URL url = null;
        try {
            url = new URL(docstoreUrl);
        }
        catch (MalformedURLException e) {
            this.log4j.error((Object)"DocstoreFilter.baseurl is malformed", (Throwable)e);
            return ++errorCount;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 401) {
                String error = conn.getResponseMessage();
                this.log4j.error((Object)("Connection failed: response code: " + conn.getResponseCode() + (error != null ? " " + error : "")));
                return ++errorCount;
            }
            this.log4j.info((Object)("DocstoreFilter.baseurl response code: " + conn.getResponseCode() + ", 200 or 401 is ok"));
            conn.disconnect();
        }
        catch (IOException e) {
            this.log4j.error((Object)"DocstoreFilter.baseurl connection failed", (Throwable)e);
            ++errorCount;
        }
        return errorCount;
    }
}

