/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.configtest;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class HttpsTest {
    Logger log4j = Log4jUtil.createLogger();

    public int test() {
        int errorCount = 0;
        for (Object props : ConfigurationProperties.get().getProperties().keySet()) {
            if (!(props instanceof String) || !ConfigurationProperties.get().get((String)props).startsWith("https")) continue;
            String url = ConfigurationProperties.get().get((String)props);
            if (!this.sslPoke((String)props, url)) {
                this.log4j.error((Object)("SSL connection failed to " + url));
                ++errorCount;
                continue;
            }
            this.log4j.info((Object)("SSL connection ok to " + url));
        }
        return errorCount;
    }

    private boolean sslPoke(String prop, String pUrl) {
        try {
            URL url = new URL(pUrl);
            int port = url.getPort();
            if (port == -1) {
                port = 443;
            }
            this.log4j.info((Object)(String.valueOf(prop) + ": Testing SSL connection to " + url.getHost() + ":" + port));
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sslsocket = (SSLSocket)factory.createSocket(url.getHost(), port);
            InputStream in = sslsocket.getInputStream();
            OutputStream out = sslsocket.getOutputStream();
            out.write(1);
            while (in.available() > 0) {
                System.out.print(in.read());
            }
        }
        catch (Exception e) {
            this.log4j.error((Object)(String.valueOf(prop) + ": SSL connection failed to: " + pUrl), (Throwable)e);
            return false;
        }
        return true;
    }
}

