/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.configtest;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.buildersenperformers.cheyenne.configtest.DbTests;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityFilterTest {
    Logger log4j = Log4jUtil.createLogger();

    public int test(String webappRoot) {
        int errorCount = 0;
        File webXmlFile = new File(String.valueOf(webappRoot) + "/WEB-INF/web.xml");
        if (!webXmlFile.exists()) {
            this.log4j.error((Object)("Web xml file " + webXmlFile + " does not exists"));
            return 1;
        }
        String lSecurityFilter = this.getSecurityFilter(webXmlFile);
        if (lSecurityFilter == null) {
            this.log4j.error((Object)"Security filter not found");
            return 1;
        }
        this.log4j.info((Object)("Security filter: " + lSecurityFilter));
        String loginPageFileProp = ConfigurationProperties.get().get(String.valueOf(lSecurityFilter) + ".LoginPage");
        this.log4j.info((Object)("LoginPage: " + webappRoot + loginPageFileProp));
        File loginPageFile = new File(String.valueOf(webappRoot) + loginPageFileProp);
        if (!loginPageFile.exists()) {
            this.log4j.error((Object)("Login page file " + loginPageFile + " does not exists"));
            ++errorCount;
        } else {
            this.log4j.info((Object)"Login page file exists");
        }
        String securityFilterPoolProp = String.valueOf(lSecurityFilter) + ".JdbcPoolName";
        this.log4j.info((Object)("Security filter pool property: " + securityFilterPoolProp));
        return errorCount += new DbTests().testPool(securityFilterPoolProp);
    }

    private String getSecurityFilter(File webXmlFile) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(webXmlFile);
            NodeList nl = doc.getElementsByTagName("filter");
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n.getNodeName().equals("filter")) {
                    NodeList nl2 = n.getChildNodes();
                    int j = 0;
                    while (j < nl2.getLength()) {
                        Node n2 = nl2.item(j);
                        if (n2.getNodeName().equals("filter-name") && n2.getTextContent().equals("KPSecurityFilter")) {
                            Element e = (Element)n;
                            return e.getElementsByTagName("filter-class").item(0).getTextContent();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log4j.error((Object)"Error parsing web.xml", (Throwable)e);
        }
        return null;
    }
}

