/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dialog.dataset;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DialogOperation;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.CheyenneServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RequestParamsJsonOperation
implements Operation,
DialogOperation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.0 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(RequestParamsJsonOperation.class);
    private Dialog iDialog = null;
    private Dataset iDataset;
    private Map<String, Object> iParams = new HashMap<String, Object>();
    private Properties iProperties;
    private String iId;
    private boolean includeRemoteIp = true;
    private boolean flattenSingleValue = true;
    private final Set<String> whitelist = new HashSet<String>();
    private final Set<String> blacklist = new HashSet<String>(Arrays.asList("secret", "parmeter_value", "password", "token", "refresh_token"));

    public void setDialog(Dialog pDialog) {
        this.iDialog = pDialog;
    }

    public Dialog getDialog() {
        return this.iDialog;
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        if (pValue == null) {
            return;
        }
        String v = String.valueOf(pValue);
        switch (pName) {
            case "id": {
                this.setId(v);
                return;
            }
            case "includeRemoteIp": {
                this.includeRemoteIp = "true".equalsIgnoreCase(v);
                return;
            }
            case "flattenSingleValue": {
                this.flattenSingleValue = "true".equalsIgnoreCase(v);
                return;
            }
            case "whitelist": {
                this.whitelist.clear();
                String[] stringArray = v.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (StringUtils.isNotBlank((CharSequence)s)) {
                        this.whitelist.add(s.trim());
                    }
                    ++n2;
                }
                return;
            }
            case "blacklist": {
                String[] stringArray = v.split(",");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String s = stringArray[n3];
                    if (StringUtils.isNotBlank((CharSequence)s)) {
                        this.blacklist.add(s.trim());
                    }
                    ++n3;
                }
                return;
            }
        }
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        if (this.iDialog == null) {
            return result;
        }
        Context chyContext = (Context)this.iDialog.getContext();
        CheyenneServletContext context = new CheyenneServletContext(chyContext);
        JSONObject root = new JSONObject();
        if (context != null && context.getRequest() != null) {
            Enumeration names = context.getRequest().getParameterNames();
            while (names.hasMoreElements()) {
                String[] values;
                String name = (String)names.nextElement();
                if (!this.whitelist.isEmpty() && !this.whitelist.contains(name) || this.blacklist.contains(name) || (values = context.getRequest().getParameterValues(name)) == null) continue;
                if (values.length == 1 && this.flattenSingleValue) {
                    root.put((Object)name, (Object)values[0]);
                    continue;
                }
                JSONArray arr = new JSONArray();
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    arr.add((Object)val);
                    ++n2;
                }
                root.put((Object)name, (Object)arr);
            }
            if (this.includeRemoteIp) {
                String ip = context.getRequest().getHeader("X-FORWARDED-FOR");
                if (ip == null || ip.isEmpty()) {
                    ip = context.getRequest().getRemoteAddr();
                }
                root.put((Object)"remote_ip", (Object)ip);
            }
        }
        String fieldName = "json";
        if (this.getId() != null) {
            fieldName = String.valueOf(this.getId()) + "_" + fieldName;
        }
        ArrayList<String> fieldVal = new ArrayList<String>();
        fieldVal.add(root.toString());
        result.put(fieldName, fieldVal);
        return result;
    }

    public List<Map<String, Object>> executeAsValueList() {
        return null;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "RequestParamsJson";
    }

    public void setId(String pId) {
        this.iId = pId;
    }

    public String getId() {
        return this.iId;
    }
}

