/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dialog.dataset;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DialogOperation;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.CheyenneServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.knowledgeplaza.util.Base64;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class RequestStringOperation
implements Operation,
DialogOperation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(RequestStringOperation.class);
    private Dialog iDialog = null;
    private Dataset iDataset;
    private Map<String, Object> iParams = new HashMap<String, Object>();
    private Properties iProperties;
    private String iId;
    private String iCtx;
    List<String> iIgnoredParams = new ArrayList<String>();

    public RequestStringOperation() {
        this.iIgnoredParams.add("request.preventCache");
        this.iIgnoredParams.add("contenttype");
    }

    public void setDialog(Dialog pDialog) {
        this.iDialog = pDialog;
    }

    public Dialog getDialog() {
        return this.iDialog;
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        if (pName.startsWith("ignore")) {
            this.iIgnoredParams.add((String)pValue);
            return;
        }
        if (pName.equals("ctx")) {
            this.iCtx = (String)pValue;
            return;
        }
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        if (this.iDialog != null) {
            Context chyContext = (Context)this.iDialog.getContext();
            CheyenneServletContext context = new CheyenneServletContext(chyContext);
            if (this.iCtx != null) {
                this.buildFromCtxParams(result);
            } else {
                this.buildFromRequest(result, context);
            }
        }
        return result;
    }

    private void buildFromCtxParams(Map<String, List<Object>> result) {
        StringJoiner queryBuilder = new StringJoiner("&");
        String[] contextParts = this.iCtx.split("\\:");
        byte[] contextBytes = Base64.decode((String)contextParts[0]);
        String contextString = new String(contextBytes);
        JSON json = JSONSerializer.toJSON((Object)contextString);
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            Iterator keys = jsonObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (this.iIgnoredParams.contains(key)) continue;
                JSONArray values = jsonObj.getJSONArray(key);
                int i = 0;
                while (i < values.size()) {
                    String parameterValue = values.getString(i);
                    try {
                        queryBuilder.add(String.valueOf(key) + "=" + URLEncoder.encode(parameterValue, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        queryBuilder.add(String.valueOf(key) + "=" + parameterValue);
                    }
                    ++i;
                }
            }
        }
        String fieldName = "query";
        if (this.getId() != null) {
            fieldName = String.valueOf(this.getId()) + "_" + fieldName;
        }
        ArrayList<String> lFieldValue = new ArrayList<String>();
        lFieldValue.add(queryBuilder.toString());
        result.put(fieldName, lFieldValue);
    }

    private void buildFromRequest(Map<String, List<Object>> result, CheyenneServletContext context) {
        if (context != null) {
            Enumeration parameterNames = context.getRequest().getParameterNames();
            StringJoiner queryBuilder = new StringJoiner("&");
            while (parameterNames.hasMoreElements()) {
                String[] parameterValues;
                String parameterName = (String)parameterNames.nextElement();
                if (this.iIgnoredParams.contains(parameterName)) continue;
                String[] stringArray = parameterValues = context.getRequest().getParameterValues(parameterName);
                int n = parameterValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterValue = stringArray[n2];
                    try {
                        queryBuilder.add(String.valueOf(parameterName) + "=" + URLEncoder.encode(parameterValue, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        queryBuilder.add(String.valueOf(parameterName) + "=" + parameterValue);
                    }
                    ++n2;
                }
            }
            String fieldName = "query";
            if (this.getId() != null) {
                fieldName = String.valueOf(this.getId()) + "_" + fieldName;
            }
            ArrayList<String> lFieldValue = new ArrayList<String>();
            lFieldValue.add(queryBuilder.toString());
            result.put(fieldName, lFieldValue);
        }
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        return null;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "RequestString";
    }

    public void setId(String pId) {
        this.iId = pId;
    }

    public String getId() {
        return this.iId;
    }
}

