/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import java.sql.Connection;
import java.sql.SQLException;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.JdbcUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.pool.JdbcConnectionPool;
import nl.knowledgeplaza.util.pool.JdbcConnectionPoolFactory;
import org.apache.log4j.Logger;

public class ChyDavLock {
    private static Logger log4j = Log4jUtil.createLogger();

    public static void setLock(int pDocId, String pUsername) {
        Connection lConnection = ChyDavLock.getConnection();
        String lSql = "select * from gen_documents.set_lock(?,?)";
        Object[] lLockParams = new Object[]{new Integer(pDocId), pUsername};
        try {
            try {
                JdbcUtil.JdbcMap lLockResult = JdbcUtil.queryAsMap((Connection)lConnection, (String)lSql, (Object[])lLockParams);
                log4j.info((Object)("Set lock result:" + lLockResult));
                lConnection.commit();
            }
            catch (SQLException e) {
                log4j.error((Object)"Error setting lock", (Throwable)e);
                ChyDavLock.returnConnection(lConnection);
            }
        }
        finally {
            ChyDavLock.returnConnection(lConnection);
        }
    }

    public static String getLock(int pDocId) {
        String lUsername = null;
        Connection lConnection = ChyDavLock.getConnection();
        String lSql = "select gen_documents.get_lock(?) USERNAME";
        Object[] lLockParams = new Object[]{new Integer(pDocId)};
        try {
            try {
                JdbcUtil.JdbcMap lLockResult = JdbcUtil.queryAsMap((Connection)lConnection, (String)lSql, (Object[])lLockParams);
                lUsername = lLockResult.getString("username");
                log4j.info((Object)("Get lock result:" + lLockResult));
                lConnection.commit();
            }
            catch (SQLException e) {
                log4j.error((Object)"Error setting lock", (Throwable)e);
                ChyDavLock.returnConnection(lConnection);
            }
        }
        finally {
            ChyDavLock.returnConnection(lConnection);
        }
        return lUsername;
    }

    public static void removeLock(int pDocId) {
        Connection lConnection = ChyDavLock.getConnection();
        String lSql = "select * from gen_documents.remove_lock(?)";
        Object[] lLockParams = new Object[]{new Integer(pDocId)};
        try {
            try {
                JdbcUtil.JdbcMap lLockResult = JdbcUtil.queryAsMap((Connection)lConnection, (String)lSql, (Object[])lLockParams);
                log4j.info((Object)("Remove lock result:" + lLockResult));
                lConnection.commit();
            }
            catch (SQLException e) {
                log4j.error((Object)"Error removing lock", (Throwable)e);
                ChyDavLock.returnConnection(lConnection);
            }
        }
        finally {
            ChyDavLock.returnConnection(lConnection);
        }
    }

    private static Connection getConnection() {
        String lConnectionPoolName = ConfigurationProperties.get().get("defaultJdbcConnectionName");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Using connection pool: " + lConnectionPoolName));
        }
        JdbcConnectionPool lJdbcConnectionPool = JdbcConnectionPoolFactory.getConnectionPool((String)lConnectionPoolName);
        Connection lConnection = null;
        lConnection = lJdbcConnectionPool.borrowConnection();
        return lConnection;
    }

    private static void returnConnection(Connection pConnection) {
        String lConnectionPoolName = ConfigurationProperties.get().get("defaultJdbcConnectionName");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Using connection pool: " + lConnectionPoolName));
        }
        JdbcConnectionPool lJdbcConnectionPool = JdbcConnectionPoolFactory.getConnectionPool((String)lConnectionPoolName);
        lJdbcConnectionPool.returnConnection(pConnection);
    }
}

