/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.ContentTypeUtils;
import io.milton.common.Path;
import io.milton.common.RangeUtils;
import io.milton.http.Auth;
import io.milton.http.FileItem;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.LockedException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.property.PropertySource;
import io.milton.resource.CollectionResource;
import io.milton.resource.FileResource;
import io.milton.resource.LockableResource;
import io.milton.resource.MultiNamespaceCustomPropertyResource;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import nl.buildersenperformers.cheyenne.dav.ChyAuthorisation;
import nl.buildersenperformers.cheyenne.dav.ChyDavLock;
import nl.buildersenperformers.cheyenne.dav.ChyFolderResource;
import nl.buildersenperformers.cheyenne.dav.ChyResourceBuilder;
import nl.buildersenperformers.cheyenne.util.CheyenneServerContent;
import nl.buildersenperformers.cheyenne.util.DocStore;
import nl.buildersenperformers.utls.logUtil;
import org.apache.log4j.Logger;

public class ChyDocumentResource
extends ChyAuthorisation
implements FileResource,
LockableResource,
MultiNamespaceCustomPropertyResource {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.15.2.3 $";
    private static Logger log4j = Logger.getLogger((String)"nl.buildersenperformers.cheyenne.dav");
    private Date iDateCreated = null;
    private Date iDateModified = null;
    protected String iName = null;
    private String iDocStoreLoc = null;
    private String iDocStoreLocNew = null;
    private String iDocId = null;
    private boolean iLocked = false;
    private CheyenneServerContent iChyServ = null;
    private Long iContectLength = null;
    private ChyResourceBuilder iResBuilder = null;
    Map<QName, Object> iProps = new HashMap<QName, Object>();

    public CheyenneServerContent getChyServ() {
        return this.iChyServ;
    }

    public void setChyServ(CheyenneServerContent pChyServ) {
        this.iChyServ = pChyServ;
    }

    public String getDocStoreLoc() {
        return this.iDocStoreLoc;
    }

    public void setDocStoreLoc(String pDocStoreLoc) {
        this.iDocStoreLoc = pDocStoreLoc;
    }

    public ChyDocumentResource(String pName, String pDocStoreLoc, CheyenneServerContent pChyServ) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource constructor called - pName=%1$s, pDocStoreLoc=%2$s, pChyServ=%3$s", pName, pDocStoreLoc, pChyServ));
        }
        this.iName = pName;
        this.iDocStoreLoc = pDocStoreLoc;
        this.iChyServ = pChyServ;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)"ChyDocumentResource constructor returned");
        }
    }

    public ChyDocumentResource() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)"ChyDocumentResource constructor called without parameters");
        }
    }

    public void copyTo(CollectionResource pArg0, String pArg1) throws NotAuthorizedException, BadRequestException, ConflictException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)logUtil.formatMsg("ChyDocumentResource.copyTo called -> ", pArg0, pArg1));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)"ChyDocumentResource.copyTo returned");
        }
    }

    @Override
    public Object authenticate(String pArg0, String pArg1) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyDocumentResource.authenticate called - user=" + pArg0));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("VP_USER", null);
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyDocumentResource.authenticate returned - result: " + user));
        }
        return user;
    }

    @Override
    public boolean authorise(Request req, Request.Method met, Auth auth) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.authorise called - req=%1$ss, met=%2$s, auth=%3$s", req, met, auth));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("VP_USER", null);
        if (auth == null) {
            req.setAuthorization(user);
            log4j.debug((Object)("auth changed to: " + user));
        }
        boolean lIsAuth = this.isAuthenticated(met);
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.authorise returns - value=%1$s", lIsAuth));
        }
        return lIsAuth;
    }

    @Override
    public String checkRedirect(Request pArg0) throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.checkRedirect called - pArg0=%1$s", pArg0));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.checkRedirect returns null", new Object[0]));
        }
        return null;
    }

    @Override
    public Date getModifiedDate() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getModifyDate getter, returns %1$s", this.iDateModified));
        }
        return this.iDateModified;
    }

    public void setModifiedDate(Date value) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setModifyDate setter, value=%1$s", value));
        }
        this.iDateModified = value;
    }

    public ChyResourceBuilder getResBuilder() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getResBuilder getter, returns=%1$s", this.iResBuilder));
        }
        return this.iResBuilder;
    }

    public void setResBuilder(ChyResourceBuilder pResBuilder) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setResBuilders setter, value=%1$s", pResBuilder));
        }
        this.iResBuilder = pResBuilder;
    }

    @Override
    public String getName() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getName getter, returns=%1$s", this.iName));
        }
        return this.iName;
    }

    @Override
    public String getRealm() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getRealm getter, returns=%1$s", this.iName));
        }
        return this.iName;
    }

    @Override
    public String getUniqueId() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getUniqueId getter, returns=null (hard coded)", new Object[0]));
        }
        return this.getDocId();
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.delete called - getName()=%1$s", this.getName()));
        }
        if (this.isLocked()) {
            log4j.info((Object)"No delete, document locked");
            throw new ConflictException("Document locked");
        }
        int lResult = this.dav_delete("P_DOC_ID=" + this.getDocId());
        if (lResult != 0) {
            throw new BadRequestException("Could not delete document. Error:" + lResult);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.delete returns", new Object[0]));
        }
    }

    public Long getContentLength() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentLength called", new Object[0]));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentLength returns value=%1$s", this.iContectLength));
        }
        if (this.iDocStoreLoc.endsWith(".fo")) {
            return (long)(this.iContectLength.doubleValue() * 1.125);
        }
        return this.iContectLength;
    }

    private Long getSizeFromDocstore() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getSizeFromDocstore called", new Object[0]));
        }
        DocStore ds = new DocStore(this.getResBuilder().getSessionID());
        Long lDocSize = null;
        try {
            lDocSize = ds.getSize(this.iDocStoreLoc);
        }
        catch (IOException e) {
            log4j.warn((Object)"DocStore.getSize failed", (Throwable)e);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getSizeFromDocstore returns - value=%1$s", lDocSize));
        }
        return lDocSize;
    }

    public void setContentLength(Long value) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentLength setter - value=%1$s", value));
        }
        this.iContectLength = value;
    }

    public String getContentType(String pArg0) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentType called - pArg0=%1$s", pArg0));
        }
        String file = Path.path((String)this.getName()).getName();
        String mime = null;
        mime = file.endsWith("docx") ? "application/vnd.openxmlformats-officedocument.wordprocessingml.document" : ContentTypeUtils.findAcceptableContentTypeForName((String)file, null);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("file:" + file + " mime:" + mime));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentType returns - value=%1$s", mime));
        }
        return mime;
    }

    public Long getMaxAgeSeconds(Auth pArg0) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getMaxAgeSeconds getter - value=null (hard coded)", new Object[0]));
        }
        return null;
    }

    public void sendContent(OutputStream out, Range pRange, Map<String, String> pArgs, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.sendContent called - out=%1$s, pRange=%2$s, pArgs=%3$s, contentType=%4$s", out, pRange, pArgs, contentType));
        }
        byte[] buff = new byte[1024];
        InputStream in = new ByteArrayInputStream(buff);
        System.out.println("sendContent + path=" + this.getName());
        String contentUrl = this.iChyServ.contextPath;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        contentUrl = String.valueOf(contentUrl) + "jsp/callDocstore.jsp;jsessionid=" + this.iChyServ.iSessionID + '?';
        if (this.iDocStoreLoc.endsWith(".fo")) {
            contentUrl = String.valueOf(contentUrl) + "xslfo=docx&";
        }
        contentUrl = String.valueOf(contentUrl) + "url=" + URLEncoder.encode(this.iDocStoreLoc, "UTF-8") + '&';
        contentUrl = String.valueOf(contentUrl) + "mimeType=" + this.getContentType(null);
        contentUrl = String.valueOf(contentUrl) + "&P_DOC_ID=" + this.getDocId();
        System.out.println(contentUrl);
        try {
            URL content = new URL(contentUrl);
            in = content.openStream();
            RangeUtils.writeRange((InputStream)in, (Range)pRange, (OutputStream)out);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.sendContent returns", new Object[0]));
        }
    }

    public void moveTo(CollectionResource newParent, String newName) throws ConflictException, NotAuthorizedException, BadRequestException {
        int lResult;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.moveTo called - newParent=%1$s, newName=%2$s", newParent, newName));
        }
        if (this.isLocked()) {
            log4j.info((Object)"No delete, document locked");
            throw new ConflictException("Document locked");
        }
        ChyFolderResource lNewParent = (ChyFolderResource)newParent;
        if (!lNewParent.isAuthCreate()) {
            throw new NotAuthorizedException("Can not write in target folder", (Resource)lNewParent);
        }
        if (!this.isAuthDelete()) {
            throw new NotAuthorizedException("Can not move file", (Resource)this);
        }
        try {
            lResult = this.rename(newName, "P_DOC_ID=" + this.getDocId() + "&P_NEW_PATH=" + URLEncoder.encode(lNewParent.getPath().toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log4j.error((Object)("Encoding error target folder: " + lNewParent.getPath().toString()), (Throwable)e);
            throw new BadRequestException((Resource)lNewParent);
        }
        if (lResult != 0) {
            throw new BadRequestException("Could not rename document. Error:" + lResult);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.moveTo returns", new Object[0]));
        }
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.processForm called - parameters=%1$s, files=%2$s", parameters, files));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.processForm called - returns null (hard coded)", new Object[0]));
        }
        return null;
    }

    public Date getCreateDate() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getCreateDate getter - value=%1$s", this.iDateCreated));
        }
        return this.iDateCreated;
    }

    public void setCreateDate(Date value) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setCreateDate setter value=%1$s", value));
        }
        this.iDateCreated = value;
    }

    public String getDocStoreLocNew() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getDocStoreLocNew getter - value=%1$s", this.iDocStoreLocNew));
        }
        return this.iDocStoreLocNew;
    }

    public void setDocStoreLocNew(String pDocStoreLocNew) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setDocStoreLocNew setter - value=%1$s", pDocStoreLocNew));
        }
        this.iDocStoreLocNew = pDocStoreLocNew;
    }

    public String getDocId() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getDocId getter - value=%1$s", this.iDocId));
        }
        return this.iDocId;
    }

    public void setDocId(String pDocId) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setDocId setter - value=%1$s", pDocId));
        }
        this.iDocId = pDocId;
    }

    public LockToken getCurrentLock() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getCurrentLock called", new Object[0]));
        }
        LockToken lk = null;
        if (this.iDocId.isEmpty()) {
            LockInfo lockInfo = new LockInfo();
            lockInfo.type = LockInfo.LockType.WRITE;
            lockInfo.scope = LockInfo.LockScope.EXCLUSIVE;
            lockInfo.depth = LockInfo.LockDepth.ZERO;
            lockInfo.lockedByUser = "SYSTEM";
            LockTimeout lo = new LockTimeout(new Long(3600L));
            String token = "docname_" + this.getName();
            lk = new LockToken(token, lockInfo, lo);
        } else {
            int lDocId = Integer.parseInt(this.iDocId);
            String lLockUser = ChyDavLock.getLock(lDocId);
            if (lLockUser != null) {
                LockInfo lockInfo = new LockInfo();
                lockInfo.type = LockInfo.LockType.WRITE;
                lockInfo.scope = LockInfo.LockScope.EXCLUSIVE;
                lockInfo.depth = LockInfo.LockDepth.ZERO;
                lockInfo.lockedByUser = lLockUser;
                LockTimeout lo = new LockTimeout(new Long(3600L));
                String token = this.getToken();
                lk = new LockToken(token, lockInfo, lo);
            } else if (this.isLocked()) {
                LockInfo lockInfo = new LockInfo();
                lockInfo.type = LockInfo.LockType.WRITE;
                lockInfo.scope = LockInfo.LockScope.EXCLUSIVE;
                lockInfo.depth = LockInfo.LockDepth.ZERO;
                lockInfo.lockedByUser = "SYSTEM";
                LockTimeout lo = new LockTimeout(new Long(3600L));
                String token = this.getToken();
                lk = new LockToken(token, lockInfo, lo);
            }
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getCurrentLock returns=%1$s", lk));
        }
        return lk;
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.lock called - timeout=%1$s,lockInfo=%2$s", timeout, lockInfo));
        }
        LockResult lr = null;
        int lDocId = Integer.parseInt(this.iDocId);
        String lLockUser = ChyDavLock.getLock(lDocId);
        if (lLockUser != null || this.isLocked()) {
            lr = new LockResult(LockResult.FailureReason.ALREADY_LOCKED, null);
        } else {
            ChyDavLock.setLock(lDocId, lockInfo.lockedByUser);
            lockInfo.type = LockInfo.LockType.WRITE;
            lockInfo.scope = LockInfo.LockScope.EXCLUSIVE;
            lockInfo.depth = LockInfo.LockDepth.ZERO;
            LockTimeout lo = new LockTimeout(new Long(3600L));
            UUID UUIDtoken = UUID.randomUUID();
            String token = UUIDtoken.toString();
            LockToken lt = new LockToken(token, lockInfo, lo);
            lt.setFrom(new Date());
            lr = new LockResult(null, lt);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.lock returns=%1$s", lr));
        }
        return lr;
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.refreshLock called, token=%1$s", token));
        }
        LockResult lr = null;
        LockInfo lockInfo = new LockInfo();
        int lDocId = Integer.parseInt(this.iDocId);
        String lLockUser = ChyDavLock.getLock(lDocId);
        if (lLockUser == null) {
            log4j.warn((Object)("Refresh lock called for document " + this.getDocId() + " but no lock found"));
        }
        if (this.isLocked()) {
            lr = new LockResult(LockResult.FailureReason.ALREADY_LOCKED, null);
        } else {
            ChyDavLock.setLock(lDocId, lLockUser);
            lockInfo.type = LockInfo.LockType.WRITE;
            lockInfo.scope = LockInfo.LockScope.EXCLUSIVE;
            lockInfo.depth = LockInfo.LockDepth.ZERO;
            lockInfo.lockedByUser = lLockUser;
            LockTimeout lo = new LockTimeout(new Long(3600L));
            LockToken lt = new LockToken(token, lockInfo, lo);
            lt.setFrom(new Date());
            lr = new LockResult(null, lt);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.refreshLock returns=%1$s", lr));
        }
        return lr;
    }

    public void unlock(String token) throws NotAuthorizedException, PreConditionFailedException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.unlock called - token=%1$s", token));
        }
        int lDocId = Integer.parseInt(this.iDocId);
        ChyDavLock.removeLock(lDocId);
        Long size = this.getContentLength();
        if (size != null && size == 0L) {
            try {
                if (log4j.isInfoEnabled()) {
                    log4j.info((Object)String.format("ChyDocumentResource.unlock detected 0kb document for docId=%1$s", this.iDocId));
                }
                StringBuilder url = new StringBuilder();
                url.append("cddid=documents.zero_kb_realtime");
                url.append("&cmode=xml");
                url.append("&P_DOC_ID=").append(URLEncoder.encode(this.iDocId, "UTF-8"));
                CheyenneServerContent chy = this.getChyServ();
                if (chy != null) {
                    CheyenneServerContent call = new CheyenneServerContent(MiltonServlet.request(), url.toString(), "text/xml");
                    if (!call.isOk()) {
                        log4j.warn((Object)("zero_kb_realtime dialog call failed for docId=" + this.iDocId));
                    }
                } else {
                    log4j.warn((Object)("ChyDocumentResource.unlock: CheyenneServerContent is null, cannot trigger zero_kb_realtime for docId=" + this.iDocId));
                }
            }
            catch (Exception e) {
                log4j.error((Object)("Error while calling documents.zero_kb_realtime for docId=" + this.iDocId), (Throwable)e);
            }
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.unlock returns", new Object[0]));
        }
    }

    private String getToken() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getToken getter - value=%1$s", this.getDocId()));
        }
        return "doc_id_" + this.getDocId();
    }

    public boolean isLocked() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.isLocked getter - value=%1$s", this.iLocked));
        }
        return this.iLocked;
    }

    public void setLocked(boolean pLocked) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setLocked setter - value=%1$s", pLocked));
        }
        this.iLocked = pLocked;
    }

    private String getDbLock() {
        return null;
    }

    private void SetDbLock() {
    }

    public List<QName> getAllPropertyNames() {
        return new ArrayList<QName>(this.iProps.keySet());
    }

    public Object getProperty(QName pArg0) {
        return null;
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName pArg0) {
        return PropertySource.PropertyMetaData.UNKNOWN;
    }

    public void setProperty(QName pArg0, Object pArg1) throws PropertySource.PropertySetException, NotAuthorizedException {
        log4j.info((Object)("Doc.setProperty, QName: " + pArg0 + ", val: " + pArg1));
        this.iProps.put(pArg0, pArg1);
    }
}

