/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.Path;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.FolderResource;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.cheyenne.dav.ChyAuthorisation;
import nl.buildersenperformers.cheyenne.dav.ChyDocumentResource;
import nl.buildersenperformers.cheyenne.dav.ChyResourceBuilder;
import nl.buildersenperformers.cheyenne.util.DocStore;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ChyFolderResource
extends ChyAuthorisation
implements FolderResource {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.9.2.6 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private List<Resource> iChilds = new ArrayList<Resource>();
    private Date iDateCreated = null;
    private Date iDateModified = null;
    private String iName = null;
    private ChyResourceBuilder iResBuilder = null;

    public Resource child(String pPath) throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.child called - path=%1$s", pPath));
        }
        Iterator<Resource> iChildIter = this.iChilds.iterator();
        Resource lRes = null;
        while (iChildIter.hasNext()) {
            lRes = iChildIter.next();
            if (!lRes.getName().equals(pPath)) continue;
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyFolderResource.child returns - value=%1$s", lRes));
            }
            return lRes;
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.child returns - value=null", new Object[0]));
        }
        return null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.debug((Object)("ChyFolderResource.getChildren getter - returning " + this.iChilds.size() + " childs"));
        }
        return this.iChilds;
    }

    public void addChilds(Resource child) {
        this.iChilds.add(child);
    }

    @Override
    public Object authenticate(String pArg0, String pArg1) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyFolderResource.authenticate called - user=" + pArg0));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("VP_USER", null);
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyFolderResource.authenticate returned - result: " + user));
        }
        return user;
    }

    @Override
    public boolean authorise(Request req, Request.Method met, Auth auth) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.authorise called - req=%1$ss, met=%2$s, auth=%3$s", req, met, auth));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("VP_USER", null);
        if (auth == null) {
            req.setAuthorization(user);
            log4j.debug((Object)("auth changed to: " + user));
        }
        boolean authorised = this.isAuthenticated(met);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("authorise called, result: " + authorised));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.authorise returns - value=%1$s", authorised));
        }
        return authorised;
    }

    @Override
    public String checkRedirect(Request pArg0) throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.checkRedirect called - pArg0=%1$s", pArg0));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.checkRedirect returns null", new Object[0]));
        }
        return null;
    }

    @Override
    public Date getModifiedDate() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.getModifyDate getter, returns %1$s", this.iDateModified));
        }
        return this.iDateModified;
    }

    public void setModifiedDate(Date value) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.setModifyDate setter, value=%1$s", value));
        }
        this.iDateModified = value;
    }

    @Override
    public String getName() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.getName getter, returns=%1$s", this.iName));
        }
        return this.iName;
    }

    public void setName(String value) {
        Path lName;
        String[] lParts;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setName called, value=%1$s", value));
        }
        this.iName = (lParts = (lName = Path.path((String)value)).getParts()).length > 1 ? lParts[lParts.length - 1] : value;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.setName returns iName==%1$s", this.iName));
        }
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public String getUniqueId() {
        return null;
    }

    public Date getCreateDate() {
        return this.iDateCreated;
    }

    public void setCreateDate(Date value) {
        this.iDateCreated = value;
    }

    public CollectionResource createCollection(String newName) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDFolderResource.createCollection called, newName=%1$s", newName));
        }
        if (!this.isAuthCreate()) {
            log4j.warn((Object)"Not allowed to create");
            throw new NotAuthorizedException();
        }
        if (!newName.matches("^[^\\\\/:\\\"*?<>|#%&\ufffd]+$")) {
            throw new BadRequestException("Folder name " + newName + " has unsupported characters");
        }
        Path newUri = Path.path((Path)this.getPath(), (String)newName);
        ChyFolderResource lResult = null;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Create in " + this.getPath().toString() + " folder " + newName));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("new uri: " + newUri));
        }
        Resource newRes = this.getResBuilder().build(newUri, "&create=folder");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("newRes after build:" + newRes));
        }
        if (!(newRes instanceof ChyFolderResource)) {
            throw new NotAuthorizedException("Not allowed", newRes);
        }
        lResult = (ChyFolderResource)newRes;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDFolderResource.createCollection returns, value=" + lResult, new Object[0]));
        }
        return lResult;
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        Principal prin;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDFolderResource.createNew called, newName=%1$s, length=%2$s, contentType=%3$s", newName, length, contentType));
        }
        if (!this.isAuthCreate()) {
            log4j.warn((Object)"Not allowed to create");
            throw new NotAuthorizedException();
        }
        Path newUri = Path.path((Path)this.getPath(), (String)newName);
        File file = null;
        OutputStream os = null;
        String lExtraUrl = "";
        boolean isVersion = newUri.getName().matches("id\\{\\d+\\}.*");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("upload in " + this.getPath().toString() + " file " + newName));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("new uri: " + newUri));
        }
        if ((prin = MiltonServlet.request().getUserPrincipal()) != null) {
            lExtraUrl = String.valueOf(lExtraUrl) + "&cusername=" + prin.getName();
        }
        Resource newRes = this.getResBuilder().build(newUri, String.valueOf(lExtraUrl) + "&create=true");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("newRes after build:" + newRes));
        }
        DocStore ds = new DocStore(MiltonServlet.request().getSession().getId());
        if (newRes instanceof ChyDocumentResource) {
            ChyDocumentResource lNewDoc = (ChyDocumentResource)newRes;
            if (lNewDoc.isLocked()) {
                throw new NotAuthorizedException((Resource)lNewDoc);
            }
            if (lNewDoc.getDocId() == null) {
                throw new NotAuthorizedException();
            }
            try {
                try {
                    file = File.createTempFile(newName, "tmp");
                    os = new FileOutputStream(file);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)os);
                }
                catch (IOException e) {
                    log4j.error((Object)"upload failed", (Throwable)e);
                    throw new BadRequestException("upload failed", (Throwable)e);
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                finally {
                    os.close();
                }
            }
            if (file.length() < length) {
                log4j.error((Object)"upload failed, file smaller then expected number of bytes");
                throw new BadRequestException("upload failed, file smaller then expected number of bytes");
            }
            try {
                Long currentSize = lNewDoc.getContentLength();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Current docstore size: " + currentSize));
                    log4j.debug((Object)("path is version path?: " + isVersion));
                    log4j.debug((Object)("Replace version?: " + (!isVersion && currentSize != null && currentSize == 0L)));
                }
                if (!isVersion && currentSize != null && currentSize == 0L) {
                    Part[] lParts = new Part[]{new StringPart("sid", MiltonServlet.request().getSession().getId()), new StringPart("P_DOC_ID", lNewDoc.getDocId()), new StringPart("P_VERSION_REPLACED", "true"), new FilePart(newName, file)};
                    log4j.debug((Object)"Current version size = 0, replacing current");
                    ds.Store(file, newName, lParts, lNewDoc.getDocStoreLoc(), prin.getName());
                } else {
                    Part[] lParts = new Part[]{new StringPart("sid", MiltonServlet.request().getSession().getId()), new StringPart("P_DOC_ID", lNewDoc.getDocId()), new FilePart(newName, file)};
                    ds.Store(file, newName, lParts, lNewDoc.getDocStoreLocNew(), prin.getName());
                }
            }
            catch (IOException e) {
                log4j.error((Object)"Cannot store file", (Throwable)e);
                throw new BadRequestException("Cannot store file", (Throwable)e);
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyDFolderResource.createNew returns - value=%1$s", newRes));
            }
            return newRes;
        }
        NotAuthorizedException e = new NotAuthorizedException("Resource class: " + (newRes == null ? "null class" : newRes.getClass().getName()), newRes);
        log4j.warn((Object)"Error creating file", (Throwable)e);
        throw e;
    }

    public void copyTo(CollectionResource pArg0, String pArg1) throws NotAuthorizedException, BadRequestException, ConflictException {
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        int lResult;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)"ChyFolderResource.delete called");
        }
        if ((lResult = this.dav_delete()) != 0) {
            throw new BadRequestException("Could not delete folder. Error:" + lResult);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)"ChyFolderResource.delete returns");
        }
    }

    public Long getContentLength() {
        if (this.iChilds != null) {
            this.iChilds.size();
        }
        return null;
    }

    public String getContentType(String pArg0) {
        return "text/html";
    }

    public Long getMaxAgeSeconds(Auth pArg0) {
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        PrintWriter pw = new PrintWriter(out);
        pw.print("<html><body>");
        pw.print("<h1>" + this.getName() + "</h1>");
        pw.print("<p>" + this.getClass().getCanonicalName() + "</p>");
        this.doBody(pw);
        pw.print("</body>");
        pw.print("</html>");
        pw.flush();
    }

    protected void doBody(PrintWriter pw) {
        System.out.println("dobody - " + this.iChilds.size());
        pw.print("<ul>");
        for (Resource r : this.iChilds) {
            String href = r.getName();
            if (r instanceof CollectionResource) {
                href = String.valueOf(href) + "/";
            }
            pw.print("<li><a href='" + href + "'>" + r.getName() + "(" + r.getClass().getCanonicalName() + ")" + "</a></li>");
        }
        pw.print("</ul>");
    }

    public void moveTo(CollectionResource newParent, String newName) throws ConflictException, NotAuthorizedException, BadRequestException {
        int lResult;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.moveTo called - newParent=%1$s, newName=%2$s", newParent, newName));
        }
        if (!newName.matches("^[^\\\\/:\\\"*?<>|#%&\ufffd]+$")) {
            throw new BadRequestException("Folder name " + newName + " has unsupported characters");
        }
        ChyFolderResource lNewParent = (ChyFolderResource)newParent;
        if (!lNewParent.isAuthCreate()) {
            throw new NotAuthorizedException("Can not write in target folder", (Resource)lNewParent);
        }
        if (!this.isAuthDelete()) {
            throw new NotAuthorizedException("Can not move file", (Resource)this);
        }
        try {
            lResult = this.rename(newName, "&P_NEW_PATH=" + URLEncoder.encode(lNewParent.getPath().toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log4j.error((Object)("Encoding error target folder: " + lNewParent.getPath().toString()), (Throwable)e);
            throw new BadRequestException((Resource)lNewParent);
        }
        if (lResult != 0) {
            throw new BadRequestException("Could not rename folder. Error:" + lResult);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyFolderResource.moveTo returns", new Object[0]));
        }
    }

    public ChyResourceBuilder getResBuilder() {
        return this.iResBuilder;
    }

    public void setResBuilder(ChyResourceBuilder pResBuilder) {
        this.iResBuilder = pResBuilder;
    }
}

