/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.ContentTypeUtils;
import io.milton.common.Path;
import io.milton.common.RangeUtils;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import io.milton.servlet.MiltonServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import nl.buildersenperformers.cheyenne.dav.ChyAuthorisation;

public class ChyReadmeResource
extends ChyAuthorisation
implements GetableResource,
PropFindableResource {
    private File iFile = null;

    @Override
    public Object authenticate(String pUser, String pPassword) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyReadmeResource.authenticate called - user=" + pUser));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("GEN_USER", null);
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("ChyReadmeResource.authenticate returned - result: " + user));
        }
        return user;
    }

    @Override
    public boolean authorise(Request req, Request.Method met, Auth auth) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.authorise called - req=%1$ss, met=%2$s, auth=%3$s", req, met, auth));
        }
        Principal prin = MiltonServlet.request().getUserPrincipal();
        Auth user = null;
        user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : new Auth("GEN_USER", null);
        if (auth == null) {
            req.setAuthorization(user);
            log4j.debug((Object)("auth changed to: " + user));
        }
        boolean lIsAuth = this.isAuthenticated(met);
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.authorise returns - value=%1$s", lIsAuth));
        }
        return lIsAuth;
    }

    public ChyReadmeResource(File pFile) {
        this.iFile = pFile;
    }

    @Override
    public String getUniqueId() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.getUniqueId getter, returns=null (hard coded)", new Object[0]));
        }
        return null;
    }

    @Override
    public String getName() {
        return this.iFile.getName();
    }

    @Override
    public Date getModifiedDate() {
        return new Date(this.iFile.lastModified());
    }

    @Override
    public String checkRedirect(Request pRequest) throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.checkRedirect called - pArg0=%1$s", pRequest));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.checkRedirect returns null", new Object[0]));
        }
        return null;
    }

    public Date getCreateDate() {
        return null;
    }

    public void sendContent(OutputStream pOut, Range pRange, Map<String, String> pParams, String pContentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        FileInputStream in = new FileInputStream(this.iFile);
        RangeUtils.writeRange((InputStream)in, (Range)pRange, (OutputStream)pOut);
    }

    public Long getMaxAgeSeconds(Auth pAuth) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.getMaxAgeSeconds getter - value=null (hard coded)", new Object[0]));
        }
        return null;
    }

    public String getContentType(String pAccepts) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.getContentType called - pAccepts=%1$s", pAccepts));
        }
        String file = Path.path((String)this.getName()).getName();
        String mime = null;
        mime = file.endsWith("docx") ? "application/vnd.openxmlformats-officedocument.wordprocessingml.document" : ContentTypeUtils.findAcceptableContentTypeForName((String)file, null);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("file:" + file + " mime:" + mime));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyReadmeResource.getContentType returns - value=%1$s", mime));
        }
        return mime;
    }

    public Long getContentLength() {
        return this.iFile.length();
    }
}

