/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.Path;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import java.security.Principal;
import nl.buildersenperformers.cheyenne.dav.ChyResourceBuilder;
import nl.buildersenperformers.cheyenne.util.CheyenneServerContent;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class ChyResourceFactory
implements ResourceFactory {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.6 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private CheyenneServerContent chyContent;
    private boolean runsFromRoot = false;
    private ChyResourceBuilder iResBuild = null;

    public ChyResourceFactory() {
        String lrunsFromRoot = ConfigurationProperties.get().get("ChyDav.runsFromRoot");
        this.iResBuild = new ChyResourceBuilder();
        if (lrunsFromRoot != null && lrunsFromRoot.equalsIgnoreCase("true")) {
            this.runsFromRoot = true;
        }
    }

    public Resource getResource(String pHost, String pPath) throws NotAuthorizedException, BadRequestException {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyResourceFactory.getResource called - path=%1$s, host=%2$s", pPath, pHost));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("getResource: url: " + pPath));
        }
        String lPath = this.fixPath(pPath);
        Path path = Path.path((String)lPath);
        Resource r = this.find(path);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("_found: " + r + " for url: " + pPath + " and path: " + path));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyResourceFactory.returns - value=%1$s", r));
        }
        return r;
    }

    private Resource find(Path path) throws NotAuthorizedException, BadRequestException {
        Path lPath = path;
        return this.parse(lPath);
    }

    public String fixPath(String path) {
        String lWebdav = "/webdav";
        int lWebdavIdx = path.indexOf(lWebdav);
        if (lWebdavIdx < 0) {
            return path;
        }
        return path.substring(lWebdavIdx + lWebdav.length());
    }

    private Resource parse(Path path) throws NotAuthorizedException, BadRequestException {
        Principal prin = MiltonServlet.request().getUserPrincipal();
        if (prin != null) {
            return this.iResBuild.build(path, "&cusername=" + prin.getName());
        }
        return this.iResBuild.build(path);
    }
}

