/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.Path;
import io.milton.http.Auth;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.servlet.Config;
import io.milton.servlet.DefaultMiltonConfigurator;
import io.milton.servlet.FilterConfigWrapper;
import io.milton.servlet.MiltonConfigurator;
import io.milton.servlet.MiltonFilter;
import io.milton.servlet.MiltonServlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.buildersenperformers.cheyenne.dav.ChyDocumentResource;
import nl.buildersenperformers.cheyenne.dav.ChyResourceBuilder;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChyWebdavFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.3.2.1 $";
    private static org.apache.log4j.Logger log4j = Log4jUtil.createLogger();
    private static final Logger log = LoggerFactory.getLogger(MiltonFilter.class);
    private FilterConfigWrapper config;
    private ServletContext servletContext;
    protected HttpManager httpManager;
    protected MiltonConfigurator configurator;
    private String[] excludeMiltonPaths;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.config = new FilterConfigWrapper(config);
            this.servletContext = config.getServletContext();
            String configuratorClassName = config.getInitParameter("milton.configurator");
            this.configurator = configuratorClassName != null ? (MiltonConfigurator)DefaultMiltonConfigurator.instantiate((String)configuratorClassName) : new DefaultMiltonConfigurator();
            log.info("Using configurator: " + this.configurator.getClass());
            String sExcludePaths = config.getInitParameter("milton.exclude.paths");
            log.info("init: exclude paths: " + sExcludePaths);
            if (sExcludePaths != null) {
                this.excludeMiltonPaths = sExcludePaths.split(",");
            }
            this.httpManager = this.configurator.configure((Config)this.config);
        }
        catch (ServletException ex) {
            log.error("Exception starting milton servlet", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        log.debug("destroy");
        if (this.configurator == null) {
            return;
        }
        this.configurator.shutdown();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)req;
            String url = hsr.getRequestURI();
            String logMsg = "";
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyWebdavFilter.doFilter called - method=%1$s, uri=%2$s", hsr.getMethod(), url));
            }
            if (this.excludeMiltonPaths != null) {
                String[] stringArray = this.excludeMiltonPaths;
                int n = this.excludeMiltonPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (url.startsWith(s)) {
                        fc.doFilter(req, resp);
                        return;
                    }
                    ++n2;
                }
            }
            this.doMiltonProcessing((HttpServletRequest)req, (HttpServletResponse)resp);
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)"ChyWebdavFilter.doFilter returns");
            }
        } else {
            fc.doFilter(req, resp);
        }
    }

    private void doGet(HttpServletRequest pHsr, HttpServletResponse pResp) throws ServletException {
        log4j.info((Object)"ChyWEBDAVFilter.doGet called");
        MiltonServlet.setThreadlocals((HttpServletRequest)pHsr, (HttpServletResponse)pResp);
        String lPath = pHsr.getRequestURI();
        lPath = this.fixPath(lPath);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Get path: " + lPath));
        }
        byte[] buff = new byte[1024];
        InputStream in = new ByteArrayInputStream(buff);
        ChyResourceBuilder lRB = new ChyResourceBuilder();
        try {
            try {
                ChyDocumentResource lDR = (ChyDocumentResource)lRB.build(Path.path((String)lPath));
                String iDocStoreLoc = lDR.getDocStoreLoc();
                pResp.setHeader("Content-Length", lDR.getContentLength().toString());
                String contentUrl = lDR.getChyServ().contextPath;
                contentUrl = String.valueOf(contentUrl) + "jsp/callDocstore.jsp;jsessionid=" + lRB.getSessionID() + '?';
                if (iDocStoreLoc.endsWith(".fo")) {
                    contentUrl = String.valueOf(contentUrl) + "xslfo=docx&";
                }
                contentUrl = String.valueOf(contentUrl) + "url=" + URLEncoder.encode(iDocStoreLoc, "UTF-8") + '&';
                contentUrl = String.valueOf(contentUrl) + "mimeType=" + lDR.getContentType(null);
                contentUrl = String.valueOf(contentUrl) + "&P_DOC_ID=" + lDR.getDocId();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("ContentURL: " + contentUrl));
                }
                URL content = new URL(contentUrl);
                in = content.openStream();
                IOUtils.copy((InputStream)in, (OutputStream)pResp.getOutputStream());
            }
            catch (MalformedURLException e) {
                log4j.error((Object)"###Error during get", (Throwable)e);
                throw new ServletException("Error during get", (Throwable)e);
            }
            catch (IOException e) {
                log4j.error((Object)"###Error during get", (Throwable)e);
                throw new ServletException("Error during get", (Throwable)e);
            }
            catch (NotAuthorizedException e) {
                log4j.error((Object)"###Error during get", (Throwable)e);
                throw new ServletException("Error during get", (Throwable)e);
            }
            catch (BadRequestException e) {
                log4j.error((Object)"###Error during get", (Throwable)e);
                throw new ServletException("Error during get", (Throwable)e);
            }
        }
        finally {
            MiltonServlet.clearThreadlocals();
        }
        log4j.info((Object)"ChyWEBDAVFilter.doGet returns");
    }

    private void doMiltonProcessing(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        io.milton.servlet.ServletResponse response;
        io.milton.servlet.ServletRequest request;
        try {
            request = new io.milton.servlet.ServletRequest(req, this.servletContext);
            response = new io.milton.servlet.ServletResponse(resp);
        }
        catch (Throwable e) {
            log.error("Exception creating milton request/response objects", e);
            throw new IOException("Exception creating milton request/response objects", e);
        }
        try {
            try {
                Principal prin = req.getUserPrincipal();
                Auth user = null;
                user = prin != null ? new Auth(Auth.Scheme.SESSION, prin.getName(), (Object)prin) : null;
                request.setAuthorization(user);
                MiltonServlet.setThreadlocals((HttpServletRequest)req, (HttpServletResponse)resp);
                this.httpManager.process((Request)request, (Response)response);
                response.setAcceptRanges("none");
            }
            catch (IllegalStateException e) {
                log4j.error((Object)"###Error during processing of webdav request", (Throwable)e);
                MiltonServlet.clearThreadlocals();
                resp.getOutputStream().flush();
                resp.flushBuffer();
            }
        }
        finally {
            MiltonServlet.clearThreadlocals();
            resp.getOutputStream().flush();
            resp.flushBuffer();
        }
    }

    public String fixPath(String path) {
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log4j.warn((Object)"Could not URLDecode path", (Throwable)e);
        }
        String lWebdav = "/webdav";
        int lWebdavIdx = path.indexOf(lWebdav);
        if (lWebdavIdx < 0) {
            return path;
        }
        return path.substring(lWebdavIdx + lWebdav.length());
    }
}

