/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.util;

import io.milton.servlet.MiltonServlet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.log4j.Logger;

public class CheyenneServerContent {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.7 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private HttpClient client;
    private static MultiThreadedHttpConnectionManager connMan;
    public String contextPath = null;
    public String iSessionID = null;
    public Calendar iTimestamp = null;
    private InputStream in = null;
    private GetMethod get = null;
    private int iTimeout = 0;
    private String iContent = null;
    private String iStatus;
    private boolean iOk;

    public CheyenneServerContent(HttpServletRequest request, String pRequest, String pExpectedContentType) {
        this.init(request, pRequest, pExpectedContentType, null);
    }

    public CheyenneServerContent(HttpServletRequest request, String pRequest, String pExpectedContentType, HttpClient pClient) {
        this.init(request, pRequest, pExpectedContentType, pClient);
    }

    private void init(HttpServletRequest request, String pRequest, String pExpectedContentType, HttpClient pClient) {
        String lTimeout;
        String lPassword;
        String lUser;
        String lContext;
        String lPort;
        this.client = pClient;
        String lHost = ConfigurationProperties.get().get("Cheyenne.host");
        if (lHost == null) {
            lHost = "83.149.67.1";
        }
        if ((lPort = ConfigurationProperties.get().get("Cheyenne.port")) == null) {
            lPort = "8060";
        }
        if ((lContext = ConfigurationProperties.get().get("Cheyenne.context")) == null) {
            lContext = "ventureplan_stpl";
        }
        if ((lUser = ConfigurationProperties.get().get("Cheyenne.username")) == null) {
            lUser = "roge";
        }
        if ((lPassword = ConfigurationProperties.get().get("Cheyenne.password")) == null) {
            lPassword = "kpap";
        }
        if ((lTimeout = ConfigurationProperties.get().get("Cheyenne.loginTimeout")) != null) {
            this.iTimeout = Integer.parseInt(lTimeout);
        }
        String lMyContext = request.getContextPath();
        boolean expired = false;
        log4j.info((Object)("Request Context=" + lMyContext));
        log4j.info((Object)("Context" + lContext));
        if (lMyContext.equals(lContext) || lContext.equals("/")) {
            this.iSessionID = request.getSession().getId();
        } else {
            this.getSession();
            GregorianCalendar lNow = new GregorianCalendar();
            ((Calendar)lNow).add(13, -1 * this.iTimeout);
            expired = this.iSessionID == null || this.iTimestamp == null || !lNow.before(this.iTimestamp);
            log4j.info((Object)("Cheyenne.loginTimeout:" + this.iTimeout));
            if (expired) {
                log4j.info((Object)"Session expired:");
                log4j.info((Object)"");
            }
        }
        String lResponse = "";
        String lContentType = "";
        String lRequest = "http://" + lHost + ":" + lPort + lContext + "/cheyenne" + (this.iSessionID != null ? ";jsessionid=" + this.iSessionID : "") + "?" + pRequest;
        this.contextPath = "http://" + lHost + ":" + lPort + lContext + "/";
        if (expired && lUser != null && lPassword != null) {
            lRequest = String.valueOf(lRequest) + "&_username=" + lUser + "&_passwd=" + lPassword;
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Adding login info to cheyenne call");
            }
        }
        GetMethod get = new GetMethod(lRequest);
        if (this.client == null) {
            connMan = new MultiThreadedHttpConnectionManager();
            this.client = new HttpClient((HttpConnectionManager)connMan);
        }
        try {
            try {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("GET: " + lRequest));
                }
                int statusCode = this.client.executeMethod((HttpMethod)get);
                if (!lMyContext.equals("/" + lContext)) {
                    this.setSessionID();
                }
                if (statusCode != 200) {
                    log4j.error((Object)("Method failed: " + get.getStatusLine()));
                    this.setStatus("Method failed: " + get.getStatusLine());
                    this.iContent = get.getResponseBodyAsString();
                    this.setOk(false);
                } else {
                    Header[] headerArray = get.getResponseHeaders();
                    int n = headerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header hdr = headerArray[n2];
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)("Header: " + hdr.toExternalForm()));
                        }
                        if ("Content-Type".equalsIgnoreCase(hdr.getName())) {
                            lContentType = hdr.getValue();
                        }
                        ++n2;
                    }
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Got contenttype: " + lContentType));
                    }
                    if (lContentType != null && lContentType.indexOf(pExpectedContentType) == -1) {
                        lResponse = null;
                        this.setOk(false);
                        this.setStatus("Invalid Content");
                        this.iContent = get.getResponseBodyAsString();
                        log4j.warn((Object)this.getStatus());
                        log4j.warn((Object)this.iContent);
                    } else {
                        this.iContent = get.getResponseBodyAsString();
                        this.setOk(true);
                    }
                }
            }
            catch (HttpException e) {
                log4j.error((Object)e);
                this.setOk(false);
                this.setStatus(e.getMessage());
                get.releaseConnection();
            }
            catch (IOException e) {
                log4j.error((Object)e);
                this.setOk(false);
                this.setStatus(e.getMessage());
                get.releaseConnection();
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * Loose catch block
     */
    public CheyenneServerContent(HttpServletRequest request, String pRequest, String pExpectedContentType, File dest) {
        String lContext;
        String lPort;
        String lHost = ConfigurationProperties.get().get("Cheyenne.host");
        if (lHost == null) {
            lHost = request.getLocalName();
        }
        if ((lPort = ConfigurationProperties.get().get("Cheyenne.port")) == null) {
            lPort = "" + request.getLocalPort();
        }
        if ((lContext = ConfigurationProperties.get().get("Cheyenne.context")) == null) {
            lContext = request.getContextPath();
        }
        String lUser = ConfigurationProperties.get().get("Cheyenne.username");
        String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
        String lResponse = "";
        this.iSessionID = request.getSession().getId();
        String lRequest = "http://" + lHost + ":" + lPort + lContext + "/cheyenne";
        if (this.iSessionID != null) {
            lRequest = String.valueOf(lRequest) + ";jsessionid=" + this.iSessionID;
        }
        lRequest = String.valueOf(lRequest) + "?" + pRequest;
        if (lUser != null && lPassword != null) {
            lRequest = String.valueOf(lRequest) + "&_username=" + lUser + "&_passwd=" + lPassword;
        }
        GetMethod get = new GetMethod(lRequest);
        if (this.client == null) {
            connMan = new MultiThreadedHttpConnectionManager();
            this.client = new HttpClient((HttpConnectionManager)connMan);
        }
        try {
            try {
                this.client.executeMethod((HttpMethod)get);
                String lContentType = get.getResponseHeader("Content-Type").toString();
                this.setSessionID();
                if (log4j.isInfoEnabled()) {
                    log4j.info((Object)("Got contenttype: " + lContentType));
                }
                if (lContentType.indexOf(pExpectedContentType) == -1) {
                    lResponse = null;
                    this.setOk(false);
                    this.setStatus("Invalid Content");
                    this.iContent = get.getResponseBodyAsString();
                    log4j.error((Object)("Invalid content, got type: " + lContentType + ", expected: " + pExpectedContentType));
                } else {
                    int len;
                    FileOutputStream file_out = new FileOutputStream(dest);
                    DataOutputStream data_out = new DataOutputStream(file_out);
                    byte[] b = new byte[1024];
                    InputStream in = get.getResponseBodyAsStream();
                    while ((len = in.read(b)) != -1) {
                        data_out.write(b, 0, len);
                    }
                    in.close();
                    file_out.close();
                    this.setOk(true);
                }
            }
            catch (FileNotFoundException e) {
                log4j.error((Object)e);
                this.setOk(false);
                get.releaseConnection();
            }
            catch (HttpException e) {
                log4j.error((Object)e);
                this.setOk(false);
                this.setStatus(e.getMessage());
                get.releaseConnection();
            }
            catch (IOException e) {
                log4j.error((Object)e);
                this.setOk(false);
                this.setStatus(e.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                get.releaseConnection();
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public String getContent() {
        if ((this.iContent == null || this.iContent.length() == 0) && this.iOk) {
            try {
                this.iContent = IOUtil.toString((InputStream)this.in);
                this.in.close();
            }
            catch (Exception e) {
                log4j.error((Object)"Could not get content", (Throwable)e);
                System.out.println(e.getMessage());
            }
        }
        return this.iContent;
    }

    public void setContent(String content) {
        this.iContent = content;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public boolean isOk() {
        return this.iOk;
    }

    public void setOk(boolean ok) {
        this.iOk = ok;
    }

    public void setSessionID() {
        if (this.client != null) {
            Cookie[] lCookies;
            HttpState state = this.client.getState();
            Cookie[] cookieArray = lCookies = state.getCookies();
            int n = lCookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie lCookie = cookieArray[n2];
                if (lCookie.getName().equals("JSESSIONID")) {
                    this.iSessionID = lCookie.getValue();
                    this.iTimestamp = new GregorianCalendar();
                    MiltonServlet.request().getSession().setAttribute("ChySessionID", (Object)this.iSessionID);
                    MiltonServlet.request().getSession().setAttribute("ChySessionTimeout", (Object)this.iTimestamp);
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Got session id: " + this.iSessionID));
                    }
                }
                ++n2;
            }
        }
    }

    public void getSession() {
        this.iSessionID = (String)MiltonServlet.request().getSession().getAttribute("ChySessionID");
        this.iTimestamp = (Calendar)MiltonServlet.request().getSession().getAttribute("ChySessionTimeout");
    }

    public static int post(HttpServletRequest request, Part[] postvars) throws HttpException, IOException {
        String lContext;
        String lPort;
        if (connMan == null) {
            connMan = new MultiThreadedHttpConnectionManager();
        }
        HttpClient lClient = new HttpClient((HttpConnectionManager)connMan);
        String lHost = ConfigurationProperties.get().get("Cheyenne.host");
        if (lHost == null) {
            lHost = request.getLocalName();
        }
        if ((lPort = ConfigurationProperties.get().get("Cheyenne.port")) == null) {
            lPort = "" + request.getLocalPort();
        }
        if ((lContext = ConfigurationProperties.get().get("Cheyenne.context")) == null) {
            lContext = request.getContextPath();
        }
        String lSessionID = request.getSession().getId();
        String lRequest = "http://" + lHost + ":" + lPort + lContext + "/cheyenne" + (lSessionID != null ? ";jsessionid=" + lSessionID : "") + "?";
        PostMethod post = new PostMethod(lRequest);
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(postvars, post.getParams()));
        int postStatus = lClient.executeMethod((HttpMethod)post);
        return postStatus;
    }
}

