/*
 * Decompiled with CFR 0.152.
 */
package nl.gezondheidsmeter.short_login;

import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.Principal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import nl.gezondheidsmeter.short_login.libCrypto;
import nl.gezondheidsmeter.short_login.model.AppRegRequest;
import nl.gezondheidsmeter.short_login.model.AppRegResponse;
import nl.gezondheidsmeter.short_login.model.CodeRegRequest;
import nl.gezondheidsmeter.short_login.model.GenericResponse;
import nl.gezondheidsmeter.short_login.model.LoginRequest;
import nl.gezondheidsmeter.short_login.model.LoginResponse;
import nl.knowledgeplaza.util.JdbcUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.configuration.Configuration;
import nl.knowledgeplaza.util.pool.JdbcConnectionPool;
import nl.knowledgeplaza.util.pool.JdbcConnectionPoolFactory;
import org.apache.log4j.Logger;

public class RegistrationDAO {
    private static Logger log4j = Log4jUtil.createLogger();
    private String iJdbcPoolName = null;
    private String iJdbcPoolNamePrs = null;
    private HttpServletRequest iRequest = null;
    private Principal iPrincipal = null;

    public RegistrationDAO(HttpServletRequest pRequest) {
        this.iRequest = pRequest;
        this.iJdbcPoolName = Configuration.get().get((Object)this, "verkortelogin.JdbcPoolName");
        this.iJdbcPoolNamePrs = Configuration.get().get((Object)this, "verkortelogin.PrsJdbcPoolName");
        if (pRequest != null) {
            this.iPrincipal = this.iRequest.getUserPrincipal();
        }
    }

    int RegisterApp(AppRegRequest pReq, AppRegResponse pResp) throws ServletException {
        log4j.info((Object)"RegistrationDAO.registerApp called");
        Connection lConn = null;
        int lResult = 0;
        int lPrsNr = 0;
        try {
            lConn = this.getConnection(this.iJdbcPoolNamePrs);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Getting user id...");
            }
            lPrsNr = this.getPersNummer(this.iPrincipal.getName());
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("user id= " + lPrsNr));
            }
        }
        catch (SQLException e) {
            log4j.error((Object)"Could not register app", (Throwable)e);
            throw new ServletException("Could not get userid", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolNamePrs);
        }
        if (lPrsNr > 0) {
            try {
                lConn = this.getConnection(this.iJdbcPoolName);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Registering app...");
                }
                String lSQL = "{call APP_SECURITY.RegisterApp(?,?,?,?,?,?,?,?,?,?)}";
                CallableStatement lStmt = lConn.prepareCall(lSQL);
                DeviceType lDeviceType = DeviceType.valueOf(pReq.getDeviceType());
                lStmt.setString(1, pReq.getUserAppID());
                lStmt.registerOutParameter(1, 12);
                lStmt.setInt(2, lPrsNr);
                lStmt.setInt(3, (int)pReq.getAppId());
                lStmt.setString(4, pReq.getDeviceID());
                lStmt.setInt(5, lDeviceType.ordinal());
                lStmt.setString(6, pReq.getDeviceName());
                lStmt.setString(7, pReq.getImei());
                lStmt.setString(8, pReq.getPhoneNumber());
                lStmt.registerOutParameter(9, 4);
                lStmt.registerOutParameter(10, 12);
                lStmt.execute();
                lResult = lStmt.getInt(9);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("result (1=good): " + lResult));
                }
                if (lResult == 1) {
                    pResp.setUserAppID(lStmt.getString(1));
                    pResp.setSharedSecret(lStmt.getString(10));
                }
                lConn.commit();
            }
            catch (SQLException e) {
                log4j.error((Object)"Could not register app", (Throwable)e);
                throw new ServletException("Could not register app", (Throwable)e);
            }
            finally {
                this.releaseConnection(lConn, this.iJdbcPoolName);
            }
        }
        log4j.info((Object)"RegistrationDAO.registerApp returns");
        return lResult;
    }

    void RegisterCode(CodeRegRequest pReq, GenericResponse pResp) throws InvalidParameterException, ServletException {
        Connection lConn = null;
        int lPrsNr = 0;
        try {
            if (!pReq.getCode().equals(pReq.getCodeVerify())) {
                throw new InvalidParameterException("Code and CodeVerify are not equal");
            }
            lPrsNr = this.getPersNummer(this.iPrincipal.getName());
            String lSharedSecret = this.getSharedSecret(lPrsNr, pReq.getUserAppID());
            if (lSharedSecret == null) {
                throw new InvalidParameterException("Not app registration known");
            }
            String lSigVal = pReq.getCode() + "#" + pReq.getCodeVerify() + "#" + pReq.getUserAppID();
            if (!libCrypto.verifySignature(lSharedSecret, lSigVal, pReq.getSignature())) {
                throw new InvalidParameterException("Signature invallid");
            }
        }
        catch (GeneralSecurityException e) {
            log4j.error((Object)"Error validating signature", (Throwable)e);
            throw new ServletException("Error validating signature", (Throwable)e);
        }
        try {
            lConn = this.getConnection(this.iJdbcPoolName);
            String lSQL = "{call APP_SECURITY.RegisterCode(?,?,?,?)}";
            CallableStatement lStmt = lConn.prepareCall(lSQL);
            lStmt.setString(1, pReq.getUserAppID());
            lStmt.setInt(2, lPrsNr);
            lStmt.setString(3, pReq.getCode());
            lStmt.registerOutParameter(4, 4);
            lStmt.execute();
            int lResult = lStmt.getInt(4);
            if (lResult != 1) {
                throw new ServletException("Error during saving code");
            }
            lConn.commit();
        }
        catch (SQLException e) {
            log4j.error((Object)"Error saving code", (Throwable)e);
            throw new ServletException("Error saving code", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPersNummer(String pUser) {
        log4j.info((Object)("RegistrationDAO.getPersNummer called, pUser=" + pUser));
        Connection lConn = null;
        int lPrsNr = 0;
        String lSQL = "SELECT TO_NUMBER(TO_CHAR(prs_persoon_nr,'J')) prs_persoon_nr FROM prs_persoon WHERE prs_init=?";
        try {
            lConn = this.getConnection(this.iJdbcPoolNamePrs);
            Object[] lParams = new Object[]{pUser};
            JdbcUtil.JdbcMap lResult = JdbcUtil.queryAsMap((Connection)lConn, (String)lSQL, (Object[])lParams);
            lPrsNr = lResult.getInt("PRS_PERSOON_NR");
        }
        catch (SQLException e) {
            log4j.error((Object)"Could not get PersNr", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolNamePrs);
        }
        log4j.info((Object)("RegistrationDAO.getPersNummer returns, value=" + lPrsNr));
        return lPrsNr;
    }

    public String getSharedSecret(int pPrsPersoonNr, String pUserAppId) throws ServletException {
        log4j.info((Object)("RegistrationDAO.getSharedSecret called, pUserNr=" + pPrsPersoonNr + " pUserAppId=" + pUserAppId));
        String lSharedSecret = null;
        Connection lConn = null;
        String lSQL = "select app_security.getsharedsecret(?,?) shared_secret from dual";
        Object[] lParams = new Object[]{new Integer(pPrsPersoonNr), pUserAppId};
        try {
            lConn = this.getConnection(this.iJdbcPoolName);
            JdbcUtil.JdbcMap lResult = JdbcUtil.queryAsMap((Connection)lConn, (String)lSQL, (Object[])lParams);
            lSharedSecret = lResult.getString("shared_secret");
        }
        catch (SQLException e) {
            log4j.error((Object)"Could not get shared secret", (Throwable)e);
            throw new ServletException("Could not get shared secret", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolName);
        }
        log4j.info((Object)("RegistrationDAO.getSharedSecret returns, value=" + lSharedSecret));
        return lSharedSecret;
    }

    public String login(LoginRequest pReq, LoginResponse pResp) throws ServletException {
        Connection lConn = null;
        String lUsername = null;
        int lPrsNr = 0;
        int lResult = 0;
        try {
            lConn = this.getConnection(this.iJdbcPoolName);
            String lSQL = "{call APP_SECURITY.login(?,?,?,?)}";
            CallableStatement lStmt = lConn.prepareCall(lSQL);
            lStmt.setString(1, pReq.getUserAppID());
            lStmt.setString(2, pReq.getIDHash());
            lStmt.registerOutParameter(3, 4);
            lStmt.registerOutParameter(4, 4);
            lStmt.execute();
            lResult = lStmt.getInt(3);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Login result: " + lResult));
            }
            if (lResult == 1) {
                lPrsNr = lStmt.getInt(4);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Got user id: " + lPrsNr));
                }
                lUsername = this.getUsername(lPrsNr);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Got user name: " + lUsername));
                }
            }
            lConn.commit();
        }
        catch (SQLException e) {
            log4j.error((Object)"Error during login", (Throwable)e);
            throw new ServletException("Error during login", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolName);
        }
        return lUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsername(int pPrsNr) {
        String lUsername = null;
        Connection lConn = null;
        String lSQL = "SELECT prs_init FROM prs_persoon WHERE prs_persoon_nr=TO_DATE(?,'J')";
        try {
            lConn = this.getConnection(this.iJdbcPoolNamePrs);
            Object[] lParams = new Object[]{new Integer(pPrsNr)};
            JdbcUtil.JdbcMap lResult = JdbcUtil.queryAsMap((Connection)lConn, (String)lSQL, (Object[])lParams);
            lUsername = lResult.getString("prs_init");
        }
        catch (SQLException e) {
            log4j.error((Object)"Could not get username", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolNamePrs);
        }
        return lUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login2(LoginRequest pReq, LoginResponse pResp) throws ServletException {
        String lUsername = null;
        String lCodeHash = null;
        String lSharedSecret = null;
        String lDeviceID = null;
        int lPersoonId = 0;
        String lSQL = "SELECT * FROM PRS_DEVICE d WHERE d.user_app_id=?";
        Object[] lParams = new Object[]{pReq.getUserAppID()};
        Connection lConn = null;
        try {
            lConn = this.getConnection(this.iJdbcPoolName);
            JdbcUtil.JdbcMap lResult = JdbcUtil.queryAsMap((Connection)lConn, (String)lSQL, (Object[])lParams);
            lCodeHash = lResult.getString("code_hash");
            lSharedSecret = lResult.getString("shared_secret");
            lDeviceID = lResult.getString("device_id");
            lPersoonId = lResult.getInt("prs_persoon_nr");
        }
        catch (SQLException e) {
            log4j.error((Object)"Could not get username", (Throwable)e);
        }
        finally {
            this.releaseConnection(lConn, this.iJdbcPoolName);
        }
        if (lCodeHash == null || lSharedSecret == null || lDeviceID == null || lPersoonId == 0) {
            log4j.info((Object)"Not enough information for hash. Return null");
            return lUsername;
        }
        Date nu = new Date();
        long epoch = nu.getTime() / 1000L;
        long epochDrift = 0L;
        for (int i = -1; i < 2; ++i) {
            epochDrift = epoch + (long)(30 * i);
            String hash = this.calcLoginHash(epoch, lCodeHash, lSharedSecret, lDeviceID);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Calculated hash: " + hash));
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("based on date: " + nu));
            }
            if (hash == null || !hash.equals(pReq.getIDHash())) continue;
            lUsername = this.getUsername(lPersoonId);
            break;
        }
        return lUsername;
    }

    protected Connection getConnection(String pJdbcPoolName) throws SQLException {
        log4j.debug((Object)"Retrieving connection");
        log4j.debug((Object)("JdbcPool: " + pJdbcPoolName));
        if (pJdbcPoolName != null) {
            log4j.debug((Object)("Using JdbcPool " + pJdbcPoolName));
            JdbcConnectionPool lJdbcConnectionPool = JdbcConnectionPoolFactory.getConnectionPool((String)pJdbcPoolName);
            Connection lConnection = (Connection)lJdbcConnectionPool.borrowObject();
            log4j.debug((Object)"Connection retrieved.");
            return lConnection;
        }
        log4j.debug((Object)"No connection retrieved.");
        return null;
    }

    protected void releaseConnection(Connection connection, String pJdbcPoolName) {
        log4j.debug((Object)"Releasing connection...");
        JdbcConnectionPool lJdbcConnectionPool = JdbcConnectionPoolFactory.getConnectionPool((String)pJdbcPoolName);
        lJdbcConnectionPool.returnConnection(connection);
    }

    public String calcLoginHash(long pTime, String pCodeHash, String pSharedSecret, String pDeviceID) {
        long lTime = pTime / 30L;
        String data = pCodeHash + lTime + pSharedSecret + pDeviceID;
        String hash = null;
        try {
            hash = libCrypto.getSHA256(data);
        }
        catch (GeneralSecurityException e) {
            log4j.error((Object)"Cannot verify hash", (Throwable)e);
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceType {
        ANDROID,
        IOS;

    }
}

