/*
 * Decompiled with CFR 0.152.
 */
package nl.gezondheidsmeter.short_login;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.gezondheidsmeter.short_login.RegistrationDAO;
import nl.gezondheidsmeter.short_login.model.GenericResponse;
import nl.gezondheidsmeter.short_login.model.LoginRequest;
import nl.gezondheidsmeter.short_login.model.LoginResponse;
import nl.knowledgeplaza.securityfilter.SecurityFilter;
import nl.knowledgeplaza.securityfilter.SecurityFilterPrincipal;
import nl.knowledgeplaza.securityfilter.SecurityInterface;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class ShortLoginInterface
extends SecurityInterface {
    Gson gson = new Gson();
    private static Logger log4j = Log4jUtil.createLogger();

    public ShortLoginInterface(ConfigurationProperties iConfigurationProperties, SecurityFilter securityFilter) throws ServletException {
    }

    public Principal authenticate(SecurityFilter pSecurityFilter, HttpServletRequest pRequest, HttpServletResponse pResponse, Principal pExpiredPrincipal) throws ServletException {
        log4j.info((Object)"ShortLoginInterface authenticate called");
        LoginRequest lReq = new LoginRequest();
        RegistrationDAO lDAO = new RegistrationDAO(pRequest);
        try {
            LoginResponse lResp;
            String lUsername;
            lReq = (LoginRequest)this.gson.fromJson((Reader)pRequest.getReader(), lReq.getClass());
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("UserAppId: " + lReq.getUserAppID()));
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("IdHash: " + lReq.getIDHash()));
            }
            if ((lUsername = lDAO.login2(lReq, lResp = new LoginResponse())) == null) {
                GenericResponse lResp2 = new GenericResponse();
                lResp2.setError("Login failed");
                pResponse.getWriter().print(this.gson.toJson((Object)lResp2));
                pRequest.getSession().invalidate();
                log4j.info((Object)"ShortLoginInterface authenticate returns invallid login");
                return SecurityFilter.AUTHENTICATION_IN_PROGRESS;
            }
            SecurityFilterPrincipal lPrincipal = new SecurityFilterPrincipal(lUsername, null);
            log4j.info((Object)"ShortLoginInterface authenticate returns");
            return lPrincipal;
        }
        catch (IOException e) {
            log4j.error((Object)"Can not process JSON data", (Throwable)e);
            throw new ServletException("Can not process JSON data", (Throwable)e);
        }
    }

    public boolean canHandleAuthication(SecurityFilter pSecurityFilter, HttpServletRequest pRequest, HttpServletResponse pResponse) {
        log4j.info((Object)"ShortLoginInterface canHandleAuthication called");
        if (pRequest.getPathInfo() != null && (pRequest.getPathInfo().contains("app_reg") || pRequest.getPathInfo().contains("code_reg"))) {
            return false;
        }
        if (pRequest.getContentType() != null && pRequest.getContentType().equals("application/json")) {
            log4j.info((Object)"ShortLoginInterface canHandleAuthication returns true");
            return true;
        }
        log4j.info((Object)"ShortLoginInterface canHandleAuthication returns false");
        return false;
    }
}

