/*
 * Decompiled with CFR 0.152.
 */
package nl.gezondheidsmeter.short_login;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class libCrypto {
    public static boolean verifySignature(String pKey, String pValue, String pSig) throws GeneralSecurityException {
        byte[] lSig = libCrypto.hexify(pSig);
        byte[] digest = libCrypto.createSignature(pKey, pValue);
        return Arrays.equals(lSig, digest);
    }

    public static byte[] createSignature(String pKey, String pValue) throws GeneralSecurityException {
        byte[] lKey = pKey.getBytes();
        byte[] lValue = pValue.getBytes();
        try {
            SecretKeySpec macKey = new SecretKeySpec(lKey, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(macKey);
            byte[] digest = mac.doFinal(lValue);
            return digest;
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Can not create signature", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException("Can not create signature", e);
        }
    }

    public static String getSHA256(String pInput) throws GeneralSecurityException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(pInput.getBytes());
        return libCrypto.dehexify(digest);
    }

    public static byte[] hexify(String string) {
        return DatatypeConverter.parseHexBinary((String)string);
    }

    public static String dehexify(byte[] string) {
        return DatatypeConverter.printHexBinary((byte[])string).toLowerCase();
    }
}

