/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.SOAP;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.SOAP.Context;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.ExceptionUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.log4j.Logger;

public class CheyenneMessageReciever
extends AbstractInOutMessageReceiver {
    private static Logger log4j = Log4jUtil.createLogger();

    public void invokeBusinessLogic(MessageContext pIn, MessageContext pOut) throws AxisFault {
        HttpServletRequest request = (HttpServletRequest)pIn.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpServletResponse response = (HttpServletResponse)pIn.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        HttpSession sess = request.getSession(true);
        try {
            log4j.debug((Object)("SessID= " + sess.getId()));
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"SOAP Request start");
            }
            AxisOperation lOperation = pIn.getAxisOperation();
            String lDialogName = lOperation.getName().getLocalPart();
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("SOAP Operation: " + lDialogName));
            }
            SOAPEnvelope lEnv = pIn.getEnvelope();
            SOAPBody lBody = lEnv.getBody();
            OMElement lMessage = lBody.getFirstElement();
            Context lContext = new Context(request, response, ConfigurationProperties.get());
            lContext.setParameter("cddid", lDialogName);
            Iterator iter = lMessage.getChildren();
            while (iter.hasNext()) {
                OMNode node = (OMNode)iter.next();
                if (node instanceof OMText) {
                    log4j.debug((Object)("Got " + ((OMText)node).getText()));
                }
                if (!(node instanceof OMElement)) continue;
                OMElement child = (OMElement)node;
                lContext.setParameter(child.getLocalName(), child.getText().trim());
                if (!log4j.isDebugEnabled()) continue;
                log4j.debug((Object)("SOAP parameter: " + child.getLocalName() + " = " + child.getText().trim()));
            }
            try {
                Dialog lDialog = this.loadDialog(lDialogName);
                lDialog.setContext((nl.innovationinvestments.cheyenne.engine.Context)lContext);
                lDialog.loadDialog();
                Map lOutParms = lDialog.outParameters();
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                SOAPEnvelope envelope = fac.getDefaultEnvelope();
                OMNamespace ns = fac.createOMNamespace("http://cheyenne/", "res");
                OMElement responseElement = fac.createOMElement(lDialogName + "Response", ns);
                for (String key : lOutParms.keySet()) {
                    OMElement item = fac.createOMElement(new QName(key));
                    item.setText(lDialog.resolve((String)lOutParms.get(key), Dialog.ESCAPING.NONE));
                    responseElement.addChild((OMNode)item);
                }
                envelope.getBody().addChild((OMNode)responseElement);
                pOut.setEnvelope(envelope);
            }
            catch (Throwable e) {
                log4j.error((Object)ExceptionUtil.describe((Throwable)e));
                throw new AxisFault("Error", e);
            }
        }
        catch (IOException e) {
            log4j.error((Object)ExceptionUtil.describe((Throwable)e));
            throw new AxisFault("Error", (Throwable)e);
        }
    }

    private Dialog loadDialog(String cddid) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Dialog lDialog = null;
        String lPackage = ConfigurationProperties.get().get2((Object)this, "DialogPackage");
        String lClassname = null;
        try {
            if (lPackage != null && lPackage.length() > 0) {
                lClassname = lPackage + "." + cddid;
            } else {
                String lApplicationName = ConfigurationProperties.get().getApplicationName();
                lClassname = "nl.innovationinvestments.chyapp." + (lApplicationName != null && lApplicationName.length() > 0 ? lApplicationName + "." : "") + cddid;
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Trying to load class: " + lClassname));
            }
            lDialog = (Dialog)((Object)((Object)this)).getClass().getClassLoader().loadClass(lClassname).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Trying to load class: " + cddid));
            }
            lDialog = (Dialog)((Object)((Object)this)).getClass().getClassLoader().loadClass(cddid).newInstance();
        }
        return lDialog;
    }
}

