/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.SOAP;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Templates;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.pool.JdbcConnectionPool;
import nl.knowledgeplaza.util.pool.JdbcConnectionPoolFactoryServletUtils;
import org.apache.log4j.Logger;

public class Context
extends nl.innovationinvestments.cheyenne.engine.servlet.Context
implements nl.innovationinvestments.cheyenne.engine.Context {
    private static Logger log4j = Log4jUtil.createLogger();
    Map<Connection, JdbcConnectionPool> iConnectionToPool = Collections.synchronizedMap(new HashMap());

    public Context(HttpServletRequest request, HttpServletResponse response, ConfigurationProperties properties) {
        super(request, response, properties, new HashMap<String, String[]>(), null);
    }

    @Override
    public Connection borrowJdbcConnection(String id) {
        JdbcConnectionPool lJdbcConnectionPool = (JdbcConnectionPool)JdbcConnectionPoolFactoryServletUtils.getConnectionPool((HttpSession)this.iRequest.getSession(), (String)id);
        Connection lConnection = lJdbcConnectionPool.borrowConnection();
        this.iConnectionToPool.put(lConnection, lJdbcConnectionPool);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("getJdbcConnection for " + id + " -> " + lConnection));
        }
        return lConnection;
    }

    @Override
    public String getConfigurationParameter(String key) {
        String lResult = null;
        lResult = this.iProperties.get(key);
        if (lResult != null) {
            return lResult;
        }
        if ("REMOTE_ADDR".equals(key)) {
            return this.iRequest.getRemoteAddr();
        }
        return null;
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.iOutputWriter;
    }

    @Override
    public String[] getParameter(String name) {
        if (this.iParameters.containsKey(name)) {
            return (String[])this.iParameters.get(name);
        }
        return null;
    }

    public void setParameter(String name, String value) {
        String[] vals = new String[]{value};
        this.iParameters.put(name, new String[]{value});
    }

    @Override
    public Templates getTemplates(String id) {
        return null;
    }

    @Override
    public void redirectTo(String url, Dialog currentDialog) {
    }

    @Override
    public void returnJdbcConnection(Connection value) {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("returnJdbcConnection " + value));
        }
        this.iConnectionToPool.get(value).returnConnection(value);
        this.iConnectionToPool.remove(value);
    }

    @Override
    public String writeContextLog() {
        String lRetVal = "";
        for (String lKey : this.iParameters.keySet()) {
            String[] lValues = (String[])this.iParameters.get(lKey);
            lRetVal = lRetVal + "\t" + lKey + " = " + lValues[0] + "\n";
        }
        return lRetVal;
    }
}

