/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import nl.buildersenperformers.cheyenne.ChyStorageProvider.FileContainer;
import nl.buildersenperformers.cheyenne.ChyStorageProvider.StorageProvider;
import nl.buildersenperformers.cheyenne.ChyStorageProvider.StorageProviderException;
import nl.innovationinvestments.cheyenne.engine.CheyenneEngineException;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.AccessLogger;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogRuntimeContext;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogWrapper;
import nl.innovationinvestments.cheyenne.engine.servlet.HeaderUtil;
import nl.innovationinvestments.cheyenne.engine.support.XMLDataSet;
import nl.knowledgeplaza.servlets.ServletUtil;
import nl.knowledgeplaza.servlets.log4j.InitServlet;
import nl.knowledgeplaza.util.ArrayUtil;
import nl.knowledgeplaza.util.Base64;
import nl.knowledgeplaza.util.CalendarUtil;
import nl.knowledgeplaza.util.CollectionUtil;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.ExceptionUtil;
import nl.knowledgeplaza.util.GenericsUtil;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.IteratorToEnumerationAdapter;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.ObjectUtil;
import nl.knowledgeplaza.util.StringUtil;
import nl.knowledgeplaza.util.io.TeeOutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;

public class CheyenneServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.69.2.16 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private DiskFileItemFactory iFileItemFactory = null;
    private File iRepository = null;
    private StorageProvider storageProvider;
    private String defaultStorageLocation;
    private ServletContext servCtxt;
    private String servletEncodig = null;
    public static final String EXCEPTION_COUNTER = CheyenneServlet.class.getName() + ".Exception";
    volatile boolean iInitialized = false;
    private volatile String iSAXParserFactoryClassname = null;
    private final ExecutorService iExecutorService = Executors.newCachedThreadPool();
    public static final String EXCEPTION = CheyenneServlet.class.getName() + ".Exception";
    public static final String EXCEPTION_ID = CheyenneServlet.class.getName() + ".ExceptionId";
    public static final String EXCEPTION_MESSAGE = CheyenneServlet.class.getName() + ".ExceptionMessage";
    public static final String ANNOTATION_ALLOWCACHE = "allowCache";
    public static final String ANNOTATION_DOWNLOADAS = "downloadAs";
    public static final String HDR_REPOST_REQUEST = "HDR_REPOST_REQUEST";
    volatile DialogClassLoader iDialogClassLoader = null;
    private DialogRuntimeContext rctxt;
    private static final String ATTRIBUTE_KEYPAIR = CheyenneServlet.class.getName() + "..keyPair";
    private final String ATTRIBUTE_SESSION_INITIALIZED = "cheyenne.session.init";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletEncodig = servletConfig.getInitParameter("responseEncoding");
        InitServlet.setNDC((ServletContext)servletConfig.getServletContext());
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("initializing " + ((Object)((Object)this)).getClass().getName()));
        }
        servletConfig.getServletContext().setAttribute(EXCEPTION_COUNTER, (Object)new AtomicLong());
        this.servCtxt = servletConfig.getServletContext();
        this.rctxt = new DialogRuntimeContext(this.servCtxt);
        this.iFileItemFactory = new DiskFileItemFactory();
        this.iRepository = (File)this.servCtxt.getAttribute("javax.servlet.context.tempdir");
        this.iRepository.mkdirs();
        this.iFileItemFactory.setRepository(this.iRepository);
        try {
            this.storageProvider = new StorageProvider();
        }
        catch (StorageProviderException e) {
            log4j.error((Object)e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        this.defaultStorageLocation = ConfigurationProperties.get().get2((Object)this, "StorageProvider.defaultStorageLocation");
    }

    public void destroy() {
        this.rctxt.destroy();
        this.rctxt = null;
        this.iExecutorService.shutdownNow();
        Context.clearTemplates();
        super.destroy();
    }

    public void initialize() {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"Initializing CheyenneServlet...");
        }
        this.iInitialized = true;
        this.iSAXParserFactoryClassname = ConfigurationProperties.get().get2((Object)this, "javax.xml.parsers.SAXParserFactory");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("iSAXParserFactoryClassname=" + this.iSAXParserFactoryClassname));
        }
        AccessLogger.init();
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest orgRequest, HttpServletResponse response) throws IOException, ServletException {
        if (this.servletEncodig != null) {
            response.setCharacterEncoding(this.servletEncodig);
            orgRequest.setCharacterEncoding("UTF-8");
        }
        HttpServletRequest request = null;
        Context lContext = null;
        Dialog lDialog = null;
        String lRequestID = "";
        try {
            Object lParameters;
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)orgRequest)) {
                request = orgRequest;
            } else {
                lParameters = this.getParametersFromRequest(orgRequest);
                String storageLocation = orgRequest.getParameter("StorageLocation");
                if (storageLocation == null || storageLocation.isEmpty()) {
                    storageLocation = this.defaultStorageLocation;
                }
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.iFileItemFactory);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Request encoding=" + orgRequest.getCharacterEncoding()));
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Request headerencoding=" + upload.getHeaderEncoding()));
                }
                upload.setSizeMax(this.storageProvider.getMaxFileSize(storageLocation));
                this.iFileItemFactory.setSizeThreshold((int)this.storageProvider.getMaxMemSize(storageLocation));
                List items = upload.parseRequest(orgRequest);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Request parsed=" + items));
                }
                for (FileItem item : items) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("File item=" + item));
                    }
                    if (!item.isFormField()) {
                        String fileName = item.getName();
                        String contentType = item.getContentType();
                        if (fileName == null || fileName.isEmpty()) continue;
                        FileContainer file = this.storageProvider.store(storageLocation, item.getInputStream(), fileName, contentType);
                        this.addValueToParameters((Map<String, List<String>>)lParameters, item.getFieldName(), file.getStorageId() + "^^" + fileName);
                        this.addValueToParameters((Map<String, List<String>>)lParameters, item.getFieldName() + "_filename", fileName);
                        this.addValueToParameters((Map<String, List<String>>)lParameters, item.getFieldName() + "_storageid", file.getStorageId());
                        this.addValueToParameters((Map<String, List<String>>)lParameters, item.getFieldName() + "_fileid", file.getFileId() + "");
                        continue;
                    }
                    this.handleParameter((Map<String, List<String>>)lParameters, item);
                }
                Map<String, String[]> lParameters2 = this.createArrayVersionOfParameters((Map<String, List<String>>)lParameters);
                request = this.createAnonymousRequestWrapper(orgRequest, (Map<String, List<String>>)lParameters, lParameters2);
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("forceGet = " + (request.getAttribute(Context.FORCE_GET) != null)));
            }
            if (request.getAttribute(Context.FORCE_GET) != null) {
                this.doGet(request, response);
                return;
            }
            InitServlet.setNDC((HttpServletRequest)request);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"==========================");
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("processing request: " + request.getMethod() + " " + request.getRequestURL() + " / " + CollectionUtil.toString((Map)request.getParameterMap())));
            }
            if (request.getParameterMap().isEmpty()) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"post request without parameters. possible ie9 bug!!!");
                }
                response.addHeader(HDR_REPOST_REQUEST, "true");
                return;
            }
            lParameters = this;
            synchronized (lParameters) {
                if (!this.iInitialized) {
                    this.initialize();
                }
            }
            boolean isApiAuth = Boolean.TRUE.equals(request.getAttribute("cheyenne.apiAuth"));
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("isApiAuth: " + isApiAuth));
            }
            this.initSession(request, response);
            KeyPair lKeyPair = null;
            Map<Object, Object> lCntxt = null;
            if (isApiAuth) {
                lCntxt = new HashMap();
            } else {
                if (request.getParameter("cntxt") == null) {
                    throw new ServletException("Missing required anti-CSRF token 'cntxt' in POST request");
                }
                try {
                    lKeyPair = this.prepareKeyPair(request);
                    String lCntxtString = request.getParameter("cntxt");
                    lCntxt = this.StringToContext(lCntxtString, lKeyPair);
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Deserialized CNTXT: " + lCntxt));
                    }
                }
                catch (Throwable e) {
                    String errorId = this.handleThrowable(e, request, response);
                    AccessLogger.logError(request, errorId, null, lDialog, lRequestID);
                    return;
                }
            }
            String lCddid = request.getParameter("cddid");
            if (lCddid == null) {
                String string = lCddid = lCntxt.get("cddid") == null ? null : ((String[])lCntxt.get("cddid"))[0];
            }
            if (lCddid == null) {
                throw new ServletException("CDDID parameter is undefined in request or cntxt");
            }
            lDialog = this.loadDialogClass(lCddid);
            if (lDialog == null) {
                throw new ServletException("No dialog loaded (null)");
            }
            lCntxt.putAll(request.getParameterMap());
            String lTarget = request.getParameter("DD_DIAG_TARGET");
            if (lTarget == null) {
                String string = lTarget = lCntxt.get("DD_DIAG_TARGET") == null ? null : ((String[])lCntxt.get("DD_DIAG_TARGET"))[0];
            }
            if (lTarget != null) {
                lCntxt.put("target", new String[]{lTarget});
            }
            lContext = new Context(request, response, ConfigurationProperties.get(), lCntxt, null);
            lDialog.setContext((nl.innovationinvestments.cheyenne.engine.Context)lContext);
            lDialog.setDefaultJdbcConnectionName(ConfigurationProperties.get().get2((Object)this, "defaultJdbcConnectionName"));
            lRequestID = AccessLogger.logStart(request, "-", lDialog, lContext);
            if (request.getContentType().startsWith("text/xml")) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Loading XML POST data.");
                }
                SAXReader saxReader = new SAXReader();
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                Document lPostDocument = saxReader.read((InputStream)request.getInputStream());
                XMLDataSet lDataSet = new XMLDataSet("xmlPostData", lPostDocument);
                lDialog.registerDataSet(lDataSet);
            }
            if (request.getContentType().startsWith("application/json")) {
                XMLSerializer xmlSerializer;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                JSON json = JSONSerializer.toJSON((Object)sb.toString());
                String xml = "";
                if (json instanceof JSONObject) {
                    JSONObject jsonObj = (JSONObject)json;
                    this.setArrayExpandableElements(jsonObj);
                    xmlSerializer = new XMLSerializer();
                    xmlSerializer.setTypeHintsCompatibility(false);
                    xmlSerializer.setSkipNamespaces(true);
                    xmlSerializer.setTypeHintsEnabled(false);
                    xmlSerializer.setForceTopLevelObject(true);
                    xmlSerializer.setRootName("json");
                    xml = xmlSerializer.write((JSON)jsonObj);
                } else if (json instanceof JSONArray) {
                    JSONArray jsonArr = (JSONArray)json;
                    this.setArrayExpandableElements(jsonArr);
                    xmlSerializer = new XMLSerializer();
                    xmlSerializer.setTypeHintsCompatibility(false);
                    xmlSerializer.setSkipNamespaces(true);
                    xmlSerializer.setTypeHintsEnabled(false);
                    xmlSerializer.setForceTopLevelObject(true);
                    xmlSerializer.setRootName("json");
                    xmlSerializer.setArrayName("records");
                    xmlSerializer.setElementName("record");
                    xml = xmlSerializer.write((JSON)jsonArr);
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Loading JSON TO XML POST data:\n" + xml));
                }
                Document lPostDocument = new SAXReader().read((InputStream)new ByteArrayInputStream(xml.getBytes()));
                XMLDataSet lDataSet = new XMLDataSet("xmlPostData", lPostDocument);
                lDialog.registerDataSet(lDataSet);
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("submitDialog... target:" + lTarget));
            }
            lDialog.submitDialog();
        }
        catch (Throwable t) {
            String errorID = this.handleThrowable(t, request, response);
            AccessLogger.logError(request, errorID, lContext, lDialog, lRequestID);
        }
        AccessLogger.logEnd(request, "-", lContext, lDialog, lRequestID);
    }

    private void setArrayExpandableElements(JSONObject obj) {
        Iterator i = obj.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            try {
                JSONArray arr = obj.getJSONArray(key);
                arr.setExpandElements(true);
                this.setArrayExpandableElements(arr);
            }
            catch (Exception e) {
                try {
                    this.setArrayExpandableElements(obj.getJSONObject(key));
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setArrayExpandableElements(JSONArray arr) {
        for (int i = 0; i < arr.size(); ++i) {
            try {
                JSONArray arr2 = arr.getJSONArray(i);
                arr2.setExpandElements(true);
                this.setArrayExpandableElements(arr2);
                continue;
            }
            catch (Exception e) {
                try {
                    this.setArrayExpandableElements(arr.getJSONObject(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.servletEncodig != null) {
            response.setCharacterEncoding(this.servletEncodig);
        }
        PrintWriter lWriter = response.getWriter();
        Context lContext = null;
        Dialog lDialog = null;
        String lRequestID = "";
        try {
            String lXsltId;
            InitServlet.setNDC((HttpServletRequest)request);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"==========================");
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("processing request: " + request.getMethod() + " " + request.getRequestURL() + " / " + CollectionUtil.toString((Map)request.getParameterMap())));
            }
            CheyenneServlet cheyenneServlet = this;
            synchronized (cheyenneServlet) {
                if (!this.iInitialized) {
                    this.initialize();
                }
            }
            this.initSession(request, response);
            HeaderUtil.setHeaders(response);
            String lCddid = request.getParameter("cddid");
            if (lCddid == null) {
                throw new ServletException("CDDID parameter is undefined in request or cntxt");
            }
            lDialog = this.loadDialogClass(lCddid);
            if (lDialog == null) {
                throw new ServletException("No dialog loaded (null)");
            }
            if (this.servletEncodig != null) {
                lDialog.setEncoding(this.servletEncodig);
            }
            if (lDialog.getLegacyMode()) {
                Enumeration lParameterNamesEnum = request.getParameterNames();
                while (lParameterNamesEnum.hasMoreElements()) {
                    String lParameterName = (String)lParameterNamesEnum.nextElement();
                    if (lParameterName.startsWith("setCTX_")) {
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)("setting in session: " + lParameterName.substring(3) + "=" + request.getParameter(lParameterName)));
                        }
                        request.getSession().setAttribute(lParameterName.substring(3), (Object)request.getParameter(lParameterName));
                    }
                    if (!lParameterName.startsWith("clrCTX_")) continue;
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("removing session: " + lParameterName.substring(3)));
                    }
                    request.getSession().removeAttribute(lParameterName.substring(3));
                }
            }
            final PipedInputStream lPipedInputStream = new PipedInputStream();
            final PipedOutputStream lPipedOutputStream = new PipedOutputStream(lPipedInputStream);
            PipedOutputStream lOutputStream = null;
            ByteArrayOutputStream lTeeByteArrayOutputStream = null;
            if (!log4j.isDebugEnabled()) {
                lOutputStream = lPipedOutputStream;
            } else {
                lTeeByteArrayOutputStream = new ByteArrayOutputStream();
                TeeOutputStream lTeeOutputStream = new TeeOutputStream((OutputStream)lPipedOutputStream, (OutputStream)lTeeByteArrayOutputStream);
                lOutputStream = lTeeOutputStream;
            }
            final ByteArrayOutputStream lTeeByteArrayOutputStreamFinal = lTeeByteArrayOutputStream;
            lContext = new Context(request, response, ConfigurationProperties.get(), request.getParameterMap(), new PrintWriter(lOutputStream));
            lDialog.setContext((nl.innovationinvestments.cheyenne.engine.Context)lContext);
            lRequestID = AccessLogger.logStart(request, "-", lDialog, lContext);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"loadDialog...");
            }
            lDialog.loadDialog(false);
            final Dialog lDialogFinal = lDialog;
            final Context lContextFinal = lContext;
            final ArrayList<Throwable> lDialogExceptions = new ArrayList<Throwable>();
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"generateDialog...");
            }
            lDialog.generateDialogInit();
            this.iExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        lDialogFinal.setContext((nl.innovationinvestments.cheyenne.engine.Context)lContextFinal);
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)"Generating the dialog in a separate thread, the HTTP thread will wait for this one to finish.");
                        }
                        lDialogFinal.generateDialog(false);
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)"Dialog generated ok");
                        }
                    }
                    catch (Throwable e) {
                        lDialogExceptions.add(e);
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)("Problem generating the dialog, we're closing the whole pipe so the HTTP thread will not block.\n" + ExceptionUtil.describe((Throwable)e)));
                        }
                        IOUtil.close((Closeable)lPipedInputStream);
                        IOUtil.close((Closeable)lPipedOutputStream);
                        return;
                    }
                    finally {
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)"Close (and flush) stream so it can be handed over to the XSLT engine.");
                        }
                        IOUtil.close((Closeable)lContextFinal.getOutputWriter());
                    }
                    if (lTeeByteArrayOutputStreamFinal != null) {
                        try {
                            byte[] lContent = lTeeByteArrayOutputStreamFinal.toByteArray();
                            if (lContent == null || lContent.length == 0) {
                                if (log4j.isDebugEnabled()) {
                                    log4j.debug((Object)"Dialog generated no output!");
                                }
                            } else {
                                SAXReader lReader = new SAXReader();
                                ByteArrayInputStream lByteArrayInputStream = new ByteArrayInputStream(lContent);
                                Document lDocument = lReader.read((InputStream)lByteArrayInputStream);
                                lByteArrayInputStream.close();
                                StringWriter lStringWriter = new StringWriter();
                                OutputFormat lOutputFormat = OutputFormat.createPrettyPrint();
                                lOutputFormat.setEncoding("UTF-8");
                                lOutputFormat.setNewLineAfterDeclaration(false);
                                lOutputFormat.setNewlines(true);
                                XMLWriter lXMLWriter = new XMLWriter((Writer)lStringWriter, lOutputFormat);
                                lXMLWriter.write(lDocument);
                                log4j.debug((Object)lStringWriter.toString());
                            }
                        }
                        catch (Throwable e) {
                            if (log4j.isDebugEnabled()) {
                                log4j.debug((Object)ExceptionUtil.describe((Throwable)e));
                            }
                            IOUtil.close((Closeable)lPipedInputStream);
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException((Throwable)lDialogExceptions.get(0));
                        }
                    }
                }
            });
            String[] parts = request.getRequestURI().split("/");
            String redirectedUrl = (String)request.getSession().getAttribute("DialogRedirect" + parts[parts.length - 1] + "?" + request.getQueryString());
            if (redirectedUrl != null && !redirectedUrl.equals("")) {
                response.addHeader("CheyenneRedirected", request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/" + redirectedUrl);
                request.getSession().removeAttribute("DialogRedirect");
            }
            String lFilename = lDialog.getAnnotation(ANNOTATION_DOWNLOADAS);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("annotation downloadAs=" + lFilename));
            }
            if (lFilename != null) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Setting Content-Disposition to " + lFilename));
                }
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment; filename=" + lFilename);
            } else {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("annotation allowCache=" + lDialog.getAnnotation(ANNOTATION_ALLOWCACHE)));
                }
                if (!lDialog.isAnnotationTrue(ANNOTATION_ALLOWCACHE) && !HeaderUtil.isCacheHeaderSet()) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Setting NoCache headers");
                    }
                    ServletUtil.setNoCache((HttpServletResponse)response);
                }
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Resolving cmode");
            }
            if ((lXsltId = lDialog.resolveSingleVariableAsString("cmode")) != null && lXsltId.length() == 0) {
                lXsltId = null;
            }
            if (lXsltId == null) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"CMODE not found in resolve, using DD default 'DD_STYLE_DEFAULT' from configuration.");
                }
                if ((lXsltId = lContext.getConfigurationParameter("DD_STYLE_DEFAULT")) != null && lXsltId.length() == 0) {
                    lXsltId = null;
                }
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("lXsltId (aka CMODE) =" + lXsltId));
            }
            String lUnprefixedXsltId = lXsltId;
            if (lXsltId != null) {
                String lXsltIdPrefix;
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Resolving cmodeprefix");
                }
                if ((lXsltIdPrefix = lDialog.resolveSingleVariableAsString("cmodeprefix")) != null) {
                    lXsltId = lXsltIdPrefix.trim() + "/" + lXsltId.trim();
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("cmodePrefix found, new lXsltId (aka CMODE) =" + lXsltId));
                    }
                }
            }
            if (lXsltId == null) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"CMODE not set, outputting XML");
                }
                response.setContentType(lDialog.getContentType() != null ? lDialog.getContentType() : "text/xml");
                IOUtil.copy((InputStream)lPipedInputStream, (Writer)lWriter);
            } else {
                Templates lTemplates;
                HashMap<String, String[]> lCntxt = new HashMap<String, String[]>();
                Enumeration lParameterNamesEnum = request.getParameterNames();
                while (lParameterNamesEnum.hasMoreElements()) {
                    String lParameterName = (String)lParameterNamesEnum.nextElement();
                    Object[] lParameterValue = request.getParameterValues(lParameterName);
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Adding to CNTXT: " + lParameterName + " = " + ArrayUtil.toString((Object[])lParameterValue)));
                    }
                    lCntxt.put(lParameterName, (String[])lParameterValue);
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Serializing CNTXT: " + lCntxt));
                }
                ByteArrayOutputStream lByteArrayOutputStream = new ByteArrayOutputStream();
                KeyPair lKeyPair = this.prepareKeyPair(request);
                PublicKey lPublicKey = lKeyPair.getPublic();
                Cipher lCipher = Cipher.getInstance("RSA");
                lCipher.init(1, lPublicKey);
                CipherOutputStream os = new CipherOutputStream(lByteArrayOutputStream, lCipher);
                ObjectOutputStream lObjectOutputStream = new ObjectOutputStream(lByteArrayOutputStream);
                lObjectOutputStream.writeObject(lCntxt);
                String lCntxtString = null;
                try {
                    lCntxtString = this.ContextToString(lCntxt, lKeyPair);
                }
                catch (Throwable e) {
                    String errorId = this.handleThrowable(e, request, response);
                    AccessLogger.logError(request, errorId, lContextFinal, lDialog, lRequestID);
                    IOUtil.close((Closeable)lWriter);
                    return;
                }
                lXsltId = lXsltId.trim();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("XsltId=" + lXsltId + ", finding the templates"));
                }
                if ((lTemplates = lContext.getTemplates(lXsltId)) == null && !ObjectUtil.equals((Object)lXsltId, (Object)lUnprefixedXsltId)) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("XsltId=" + lXsltId + ", not found, trying unprefixed XsltId=" + lUnprefixedXsltId));
                    }
                    lTemplates = lContext.getTemplates(lUnprefixedXsltId);
                }
                if (lTemplates == null) {
                    throw new CheyenneEngineException("No templates found for " + lXsltId + (lUnprefixedXsltId == null ? "" : " and " + lUnprefixedXsltId));
                }
                Transformer lTransFormer = lTemplates.newTransformer();
                String lContentType = lTransFormer.getOutputProperty("method");
                lTransFormer.setParameter("DD_CONFIG_FILE", lDialog.resolve("%DD_CONFIG_FILE%"));
                lTransFormer.setParameter("DD_XSLT_PARAM", lDialog.resolve("%DD_XSLT_PARAM%"));
                lTransFormer.setParameter("DD_DIAG_MODE", lDialog.getDiagMode());
                lTransFormer.setParameter("cntxt", lCntxtString);
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("content type: " + lContentType));
                }
                if (lTransFormer.getOutputProperty("media-type") != null && !lTransFormer.getOutputProperty("media-type").equals("")) {
                    response.setContentType(lTransFormer.getOutputProperty("media-type"));
                } else {
                    response.setContentType("text/" + lContentType);
                }
                Source lSource = null;
                if (this.iSAXParserFactoryClassname == null) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Using JVM's XML parser");
                    }
                    lSource = new StreamSource(lPipedInputStream);
                } else {
                    try {
                        SAXParserFactory lSAXParserFactory = (SAXParserFactory)Class.forName(this.iSAXParserFactoryClassname).newInstance();
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)("SAXParserFactory=" + lSAXParserFactory.getClass().getName()));
                        }
                        lSource = new SAXSource(new InputSource(lPipedInputStream));
                    }
                    catch (IllegalAccessException e) {
                        throw new ServletException((Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new ServletException((Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                try {
                    lTransFormer.transform(lSource, new StreamResult(lWriter));
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"XSLT transform completed.");
                    }
                }
                catch (Throwable t) {
                    lDialogExceptions.add(t);
                }
                if (lDialogExceptions.size() > 0) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Exception received from dialog generation, rethrowing that");
                    }
                    if (lDialogExceptions.get(0) instanceof RuntimeException) {
                        throw (RuntimeException)lDialogExceptions.get(0);
                    }
                    throw new ServletException((Throwable)lDialogExceptions.get(0));
                }
            }
            AccessLogger.logEnd(request, "-", lContext, lDialog, lRequestID);
            if (lDialog != null) {
                lDialog.unregisterAllDataSets();
            }
        }
        catch (Throwable t) {
            String errorId = this.handleThrowable(t, request, response);
            AccessLogger.logError(request, errorId, lContext, lDialog, lRequestID);
        }
        finally {
            IOUtil.close((Closeable)lWriter);
        }
    }

    private String handleThrowable(Throwable throwable, HttpServletRequest request, HttpServletResponse response) {
        try {
            AtomicLong lExceptionCounter = (AtomicLong)request.getSession().getServletContext().getAttribute(EXCEPTION_COUNTER);
            String lId = "[" + CalendarUtil.filePrefixLong() + "_" + lExceptionCounter.addAndGet(1L) + "]";
            String lMessage = lId + "\n\n" + throwable.getMessage() + "\n\n" + ServletUtil.describeFull((HttpServletRequest)request) + "\n\n" + ExceptionUtil.describe((Throwable)throwable);
            log4j.error((Object)lMessage);
            String lExceptionHandling = ConfigurationProperties.get().get2((Object)this, "exceptionHandling");
            if (StringUtil.equalsTrueInSomeForm((String)lExceptionHandling)) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"ExceptionHandling is true, so we just print a simple text");
                }
                response.setStatus(500);
                response.setContentType("text/plain");
                response.getWriter().write("Er is een fout opgetreden, meldt het volgende nummer aan de helpdesk " + lId);
                return lId;
            }
            if (!StringUtil.isEmpty((String)lExceptionHandling)) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("ExceptionHandling is " + lExceptionHandling + ", so we will forward the request there"));
                }
                request.setAttribute(EXCEPTION, (Object)throwable);
                request.setAttribute(EXCEPTION_ID, (Object)lId);
                request.setAttribute(EXCEPTION_MESSAGE, (Object)lMessage);
                request.getRequestDispatcher(lExceptionHandling).forward((ServletRequest)new ErrorRequest(request), (ServletResponse)response);
                return lId;
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"ExceptionHandling is not set, so we will dump the exception");
            }
            log4j.error((Object)lMessage);
            response.setStatus(500);
            response.setContentType("text/plain");
            response.getWriter().write(lMessage);
            return lId;
        }
        catch (Throwable t) {
            log4j.error((Object)(ExceptionUtil.describe((Throwable)t) + "\n\n\nWHEN HANDLING:\n\n" + ExceptionUtil.describe((Throwable)throwable)));
            return "";
        }
    }

    private Dialog loadDialogClass(String cddid) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ServletException {
        Dialog lDialog = null;
        String lPackage = ConfigurationProperties.get().get2((Object)this, "DialogPackage");
        String lClassname = null;
        try {
            if (lPackage != null && lPackage.length() > 0) {
                lClassname = lPackage + "." + cddid;
            } else {
                String lApplicationName = ConfigurationProperties.get().getApplicationName();
                lClassname = "nl.innovationinvestments.chyapp." + (lApplicationName != null && lApplicationName.length() > 0 ? lApplicationName + "." : "") + cddid;
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Trying to load class: " + lClassname));
            }
            lDialog = this.iDialogClassLoader != null ? (Dialog)this.iDialogClassLoader.loadClass(lClassname).newInstance() : (Dialog)((Object)((Object)this)).getClass().getClassLoader().loadClass(lClassname).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Trying to load class: " + cddid));
            }
            lDialog = this.iDialogClassLoader != null ? (Dialog)this.iDialogClassLoader.loadClass(cddid).newInstance() : (Dialog)((Object)((Object)this)).getClass().getClassLoader().loadClass(cddid).newInstance();
        }
        return lDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialog getDialogClass(String cddid) throws ClassNotFoundException, ServletException {
        DialogWrapper wrapper = this.rctxt.getWrapper(cddid);
        if (wrapper == null) {
            CheyenneServlet cheyenneServlet = this;
            synchronized (cheyenneServlet) {
                wrapper = this.rctxt.getWrapper(cddid);
                if (wrapper == null) {
                    wrapper = new DialogWrapper(cddid, this.getServletContext(), this.rctxt);
                    this.rctxt.addWrapper(cddid, wrapper);
                }
            }
        }
        return wrapper.getDialog();
    }

    private static URL[] determineURLs(CheyenneServlet cheyenneServlet) {
        URL lURL;
        ArrayList lURLs;
        block20: {
            lURLs = GenericsUtil.newArrayList();
            lURL = null;
            try {
                File lClassesDir = new File(cheyenneServlet.getServletContext().getRealPath("/WEB-INF/classes"));
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Checking for classloader " + lClassesDir.getAbsolutePath()));
                }
                if (lClassesDir.exists()) {
                    lURL = lClassesDir.toURI().toURL();
                    if (!lURLs.contains(lURL)) {
                        lURLs.add(lURL);
                    }
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Adding to classloader " + lURL));
                    }
                }
            }
            catch (MalformedURLException e) {
                if (!log4j.isDebugEnabled()) break block20;
                log4j.debug((Object)(lURL + "\n" + ExceptionUtil.describe((Throwable)e)));
            }
        }
        File lLibDir = new File(cheyenneServlet.getServletContext().getRealPath("/WEB-INF/lib"));
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Checking for classloader " + lLibDir.getAbsolutePath()));
        }
        if (lLibDir.exists()) {
            File[] lFiles;
            for (File lJarFile : lFiles = lLibDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                try {
                    lURL = lJarFile.toURI().toURL();
                    if (!lURLs.contains(lURL)) {
                        lURLs.add(lURL);
                    }
                    if (!log4j.isDebugEnabled()) continue;
                    log4j.debug((Object)("Adding to classloader " + lURL));
                }
                catch (MalformedURLException e) {
                    if (!log4j.isDebugEnabled()) continue;
                    log4j.debug((Object)(lURL + "\n" + ExceptionUtil.describe((Throwable)e)));
                }
            }
        }
        String lClassPath = System.getProperty("java.class.path");
        String[] lClassPathItems = StringUtil.tokenizeDelimitedToArray((String)lClassPath, (String)File.pathSeparator);
        for (int i = 0; i < 0; ++i) {
            block21: {
                try {
                    File lFile = new File(lClassPathItems[i]);
                    if (lFile.exists()) {
                        lURL = lFile.toURI().toURL();
                        if (!lURLs.contains(lURL)) {
                            lURLs.add(lURL);
                        }
                        if (!log4j.isDebugEnabled()) continue;
                        log4j.debug((Object)("Adding to classloader " + lURL));
                        continue;
                    }
                }
                catch (MalformedURLException e) {
                    if (!log4j.isDebugEnabled()) break block21;
                    log4j.debug((Object)(lURL + "\n" + ExceptionUtil.describe((Throwable)e)));
                }
            }
            try {
                lURL = new URL(lClassPathItems[i]);
                if (!lURLs.contains(lURL)) {
                    lURLs.add(lURL);
                }
                if (!log4j.isDebugEnabled()) continue;
                log4j.debug((Object)("Adding to classloader " + lURL));
                continue;
            }
            catch (MalformedURLException e) {
                if (!log4j.isDebugEnabled()) continue;
                log4j.debug((Object)(lURL + "\n" + ExceptionUtil.describe((Throwable)e)));
            }
        }
        return lURLs.toArray(new URL[0]);
    }

    private KeyPair prepareKeyPair(HttpServletRequest request) throws ServletException {
        try {
            KeyPair lKeyPair = (KeyPair)request.getSession().getAttribute(ATTRIBUTE_KEYPAIR);
            if (lKeyPair == null) {
                KeyPairGenerator lKeyPairGenerator = KeyPairGenerator.getInstance("RSA");
                lKeyPairGenerator.initialize(1024);
                lKeyPair = lKeyPairGenerator.generateKeyPair();
                request.getSession().setAttribute(ATTRIBUTE_KEYPAIR, (Object)lKeyPair);
            }
            return lKeyPair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSession(HttpServletRequest request, HttpServletResponse response) {
        Dialog lDialog;
        HttpSession lSession = request.getSession();
        if (lSession.getAttribute("cheyenne.session.init") != null) {
            return;
        }
        HttpSession httpSession = lSession;
        synchronized (httpSession) {
            lSession.setAttribute("cheyenne.session.init", (Object)"working");
        }
        String lSessionInitDialog = ConfigurationProperties.get().get2((Object)this, "SessionInitDialog");
        if (lSessionInitDialog == null) {
            return;
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Initializing Session using dialog: " + lSessionInitDialog));
        }
        try {
            lDialog = this.loadDialogClass(lSessionInitDialog);
        }
        catch (Throwable e) {
            log4j.warn((Object)("Session Initialization Dialog " + lSessionInitDialog + " not found"), e);
            return;
        }
        Context lContext = new Context(request, response, ConfigurationProperties.get(), request.getParameterMap(), null);
        lDialog.setContext((nl.innovationinvestments.cheyenne.engine.Context)lContext);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("loadDialog of " + lSessionInitDialog));
        }
        lDialog.loadDialog();
        lSession.setAttribute("cheyenne.session.init", (Object)"done");
    }

    private HttpServletRequestWrapper createAnonymousRequestWrapper(HttpServletRequest lRequest, final Map<String, List<String>> lParameters, final Map<String, String[]> lParameters2) {
        HttpServletRequestWrapper lHttpServletRequestWrapper = new HttpServletRequestWrapper(lRequest){

            public String getParameter(String name) {
                List lValues = (List)lParameters.get(name);
                return lValues == null ? null : (String)lValues.get(0);
            }

            public Map<String, String[]> getParameterMap() {
                return Collections.unmodifiableMap(lParameters2);
            }

            public Enumeration<String> getParameterNames() {
                return new IteratorToEnumerationAdapter(lParameters.keySet().iterator());
            }

            public String[] getParameterValues(String name) {
                return (String[])lParameters2.get(name);
            }

            public String getContentType() {
                return "TEXT/PLAIN";
            }

            public int getContentLength() {
                return 0;
            }

            public ServletInputStream getInputStream() {
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return 0;
                    }
                };
            }
        };
        return lHttpServletRequestWrapper;
    }

    private Map<String, String[]> createArrayVersionOfParameters(Map<String, List<String>> lParameters) {
        TreeMap<String, String[]> lParameters2 = new TreeMap<String, String[]>();
        for (String lName : lParameters.keySet()) {
            lParameters2.put(lName, lParameters.get(lName).toArray(new String[0]));
        }
        return lParameters2;
    }

    private void addValueToParameters(Map<String, List<String>> lParameters, String lName, String lValue) {
        if (lValue != null) {
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            lParameters.get(lName).add(lValue);
        }
    }

    private void handleParameter(Map<String, List<String>> lParameters, FileItem lPart) throws UnsupportedEncodingException {
        if (lPart.isFormField()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("multipart item encoding: " + lPart.getContentType()));
            }
            String lName = lPart.getFieldName();
            String lValue = lPart.getString();
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"forcing UTF-8 decoding for multipart parameter.");
            }
            lValue = new String(lValue.getBytes("ISO-8859-1"), "UTF-8");
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("param; name=" + lName + ", value=" + lValue));
            }
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            lParameters.get(lName).add(lValue);
        }
    }

    private Map<String, List<String>> getParametersFromRequest(HttpServletRequest request) {
        TreeMap<String, List<String>> lParameters = new TreeMap<String, List<String>>();
        Enumeration lEnum = request.getParameterNames();
        while (lEnum.hasMoreElements()) {
            String lName = (String)lEnum.nextElement();
            String[] lValues = request.getParameterValues(lName);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("queryparam; name=" + lName + ", value=" + Arrays.asList(lValues)));
            }
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            ((List)lParameters.get(lName)).addAll(Arrays.asList(lValues));
        }
        return lParameters;
    }

    private Map<String, String[]> StringToContext(String pCntxtStr, KeyPair pKeypair) {
        String[] contextParts = pCntxtStr.split("\\:");
        try {
            byte[] s = Base64.decode((String)contextParts[1]);
            Signature privateSignature = Signature.getInstance("SHA256withRSA");
            privateSignature.initVerify(pKeypair.getPublic());
            privateSignature.update(contextParts[0].getBytes("UTF-8"));
            if (!privateSignature.verify(s)) {
                throw new InvalidParameterException("Context is tampered");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String[]> retVal = new HashMap<String, String[]>();
        byte[] contextBytes = Base64.decode((String)contextParts[0]);
        String contextString = new String(contextBytes);
        JSON json = JSONSerializer.toJSON((Object)contextString);
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            Iterator keys = jsonObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray values = jsonObj.getJSONArray(key);
                String[] stringArray = new String[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    stringArray[i] = values.getString(i);
                }
                retVal.put(key, stringArray);
            }
        }
        return retVal;
    }

    private String ContextToString(Map<String, String[]> pCntxt, KeyPair pKeypair) {
        JSONObject contextStruct = new JSONObject();
        for (String key : pCntxt.keySet()) {
            String[] values = pCntxt.get(key);
            JSONArray valueArray = new JSONArray();
            for (String value : values) {
                valueArray.add((Object)value);
            }
            contextStruct.put((Object)key, (Object)valueArray);
        }
        try {
            String contextBase = Base64.encodeString((String)contextStruct.toString());
            Signature privateSignature = Signature.getInstance("SHA256withRSA");
            privateSignature.initSign(pKeypair.getPrivate());
            privateSignature.update(contextBase.getBytes("UTF-8"));
            byte[] s = privateSignature.sign();
            String sign = new String(Base64.encode((byte[])s));
            return contextBase + ":" + sign;
        }
        catch (Exception e) {
            throw new RuntimeException("Signing context error", e);
        }
    }

    class ErrorRequest
    extends HttpServletRequestWrapper {
        public ErrorRequest(HttpServletRequest pRequest) {
            super(pRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }

    class DialogClassLoader
    extends URLClassLoader {
        public DialogClassLoader() {
            super(CheyenneServlet.determineURLs(CheyenneServlet.this));
        }
    }
}

