/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import nl.innovationinvestments.cheyenne.engine.CheyenneEngineException;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.DialogUtil;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.pool.JdbcConnectionPool;
import nl.knowledgeplaza.util.pool.JdbcConnectionPoolFactoryServletUtils;
import org.apache.log4j.Logger;

public class Context
implements nl.innovationinvestments.cheyenne.engine.Context {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.32.2.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    protected HttpServletRequest iRequest;
    protected HttpServletResponse iResponse;
    protected ConfigurationProperties iProperties;
    protected Map<String, String[]> iParameters;
    protected PrintWriter iOutputWriter;
    Map<Connection, JdbcConnectionPool> iConnectionToPool = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Templates> cTemplates = new HashMap<String, Templates>();
    public static final String FORCE_GET = Context.class.getName() + "..forceGet";
    private Map<String, Integer> iJdbcTypes = new HashMap<String, Integer>();

    public Context(HttpServletRequest request, HttpServletResponse response, ConfigurationProperties properties, Map<String, String[]> parameters, PrintWriter outputWriter) {
        this.iRequest = request;
        this.iResponse = response;
        this.iProperties = properties;
        this.iParameters = parameters;
        this.iOutputWriter = outputWriter;
    }

    public String getConfigurationParameter(String key) {
        String lResult = null;
        lResult = (String)this.iRequest.getAttribute(key);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("iRequest.getAttribute(" + key + ") = " + lResult));
        }
        if (lResult != null) {
            return lResult;
        }
        lResult = (String)this.iRequest.getSession().getAttribute(key);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("iRequest.getSession().getAttribute(" + key + " ) = " + lResult));
        }
        if (lResult != null) {
            return lResult;
        }
        lResult = (String)this.iRequest.getSession().getServletContext().getAttribute(key);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("iRequest.getSession().getServletContext().getAttribute(" + key + " ) = " + lResult));
        }
        if (lResult != null) {
            return lResult;
        }
        lResult = this.iProperties.get(key);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("iProperties.get(" + key + " ) = " + lResult));
        }
        if (lResult != null) {
            return lResult;
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("" + key + " checking defaults"));
        }
        if ("DD_URL".equals(key)) {
            return this.iRequest.getRequestURL() + "?cddid";
        }
        if ("DD_EXE".equals(key)) {
            return "cheyenne?";
        }
        if ("DD_PUB_BASE_URL".equals(key)) {
            return this.iRequest.getRequestURL().substring(0, this.iRequest.getRequestURL().lastIndexOf("/"));
        }
        if ("DD_STYLE_DEFAULT".equals(key)) {
            return "main";
        }
        if ("DD_SUB_NAME".equals(key)) {
            return "";
        }
        if ("cusername".equals(key)) {
            return this.iRequest.getUserPrincipal() == null ? "anonymous" : this.iRequest.getUserPrincipal().getName();
        }
        if ("SESSIONID".equals(key)) {
            return this.iRequest.getSession().getId();
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)(key + " not found"));
        }
        return null;
    }

    public PrintWriter getOutputWriter() {
        return this.iOutputWriter;
    }

    public String[] getParameter(String key) {
        return this.iParameters.get(key);
    }

    public Connection borrowJdbcConnection(String id) {
        JdbcConnectionPool lJdbcConnectionPool = (JdbcConnectionPool)JdbcConnectionPoolFactoryServletUtils.getConnectionPool((HttpSession)this.iRequest.getSession(), (String)id);
        Connection lConnection = lJdbcConnectionPool.borrowConnection();
        this.iConnectionToPool.put(lConnection, lJdbcConnectionPool);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("getJdbcConnection for " + id + " -> " + lConnection));
        }
        return lConnection;
    }

    public void returnJdbcConnection(Connection value) {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("returnJdbcConnection " + value));
        }
        this.iConnectionToPool.get(value).returnConnection(value);
        this.iConnectionToPool.remove(value);
    }

    public Templates getTemplates(String id) {
        Templates lTemplates = cTemplates.get(id);
        if (lTemplates != null) {
            return lTemplates;
        }
        try {
            String lFileName = this.iRequest.getSession().getServletContext().getRealPath("WEB-INF/xslt/" + id + ".xsl");
            if (lFileName == null) {
                return null;
            }
            File lFile = new File(lFileName);
            if (!lFile.exists()) {
                return null;
            }
            String lTransformerFactoryClassName = this.getConfigurationParameter("javax.xml.transform.TransformerFactory");
            if (lTransformerFactoryClassName == null || lTransformerFactoryClassName.length() == 0) {
                lTransformerFactoryClassName = "org.apache.xalan.processor.TransformerFactoryImpl";
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("lTransformerFactoryClassName=" + lTransformerFactoryClassName));
            }
            lTemplates = DialogUtil.createTemplatesFor((Source)new StreamSource(new FileInputStream(lFileName), lFileName), (String)lTransformerFactoryClassName);
            cTemplates.put(id, lTemplates);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return lTemplates;
    }

    public void redirectTo(String url, Dialog currentDialog) {
        try {
            if (url == null) {
                url = "cddid=" + currentDialog.getIdFull() + "&" + this.iRequest.getQueryString();
            }
            url = this.getConfigurationParameter("DD_EXE") + url;
            if (!currentDialog.getLegacyMode()) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("sendRedirect: " + url));
                }
                this.iRequest.getSession().setAttribute("DialogRedirect" + url, (Object)url);
                this.iResponse.sendRedirect(url);
            } else {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"setting forceGet attribute");
                }
                this.iRequest.setAttribute(FORCE_GET, (Object)"");
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("forward: " + url));
                }
                this.iRequest.getRequestDispatcher(url).forward((ServletRequest)this.iRequest, (ServletResponse)this.iResponse);
            }
        }
        catch (IOException e) {
            throw new CheyenneEngineException((Throwable)e);
        }
        catch (ServletException e) {
            throw new CheyenneEngineException((Throwable)e);
        }
    }

    public String writeContextLog() {
        String lRetVal = "";
        for (String lKey : this.iParameters.keySet()) {
            String[] lValues = this.iParameters.get(lKey);
            if (lValues.length == 1) {
                lRetVal = lRetVal + "\t" + lKey + " = " + lValues[0] + "\n";
                continue;
            }
            lRetVal = lRetVal + "\t" + lKey + " = {";
            for (int i = 0; i < lValues.length; ++i) {
                lRetVal = lRetVal + (i == 0 || i == lValues.length - 1 ? "" : ",") + lValues[i];
            }
            lRetVal = lRetVal + "}\n";
        }
        return lRetVal;
    }

    public void setRequest(String id, Object value) {
        if (value == null) {
            this.iRequest.removeAttribute(id);
        } else {
            this.iRequest.setAttribute(id, value);
        }
    }

    public Object getRequest(String id) {
        return this.iRequest.getAttribute(id);
    }

    public void setSession(String id, Object value) {
        if (value == null) {
            this.iRequest.getSession().removeAttribute(id);
        } else {
            this.iRequest.getSession().setAttribute(id, value);
        }
    }

    public Object getSession(String id) {
        return this.iRequest.getSession() == null ? null : this.iRequest.getSession().getAttribute(id);
    }

    public void setApplication(String id, Object value) {
        if (value == null) {
            this.iRequest.getSession().getServletContext().removeAttribute(id);
        } else {
            this.iRequest.getSession().getServletContext().setAttribute(id, value);
        }
    }

    public Object getApplication(String id) {
        return this.iRequest.getSession() == null ? null : this.iRequest.getSession().getServletContext().getAttribute(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJdbcType(String id) {
        int lJdbcType = 0;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Getting Database type for: " + id));
        }
        if (this.iJdbcTypes.containsKey(id)) {
            lJdbcType = this.iJdbcTypes.get(id);
        } else {
            Connection lConnect = this.borrowJdbcConnection(id);
            try {
                String lProductName = lConnect.getMetaData().getDatabaseProductName().toLowerCase();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Database productname: " + lProductName));
                }
                if (DialogUtil.getDbTypes().containsKey(lProductName)) {
                    lJdbcType = (Integer)DialogUtil.getDbTypes().get(lProductName);
                    this.iJdbcTypes.put(id, lJdbcType);
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Database type id: " + lJdbcType));
                    }
                }
            }
            catch (SQLException e) {
                lJdbcType = -1;
                log4j.warn((Object)"Datebase type not found");
            }
            finally {
                this.returnJdbcConnection(lConnect);
            }
        }
        return lJdbcType;
    }

    public void destroy() {
        cTemplates.clear();
        this.iJdbcTypes.clear();
    }

    public static void clearTemplates() {
        cTemplates.clear();
    }
}

