/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.docstore.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ThreadFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import nl.innovationinvestments.docstore.util.QueryUtil;
import nl.knowledgeplaza.servlets.log4j.InitServlet;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.IteratorToEnumerationAdapter;
import nl.knowledgeplaza.util.RandomGUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

public class DocstoreFilter
implements Filter {
    public static final String SOURCECODE_VERSION = "$Revision: 1.14 $";
    static Logger log4j = Logger.getLogger((String)DocstoreFilter.class.getName());
    Map<String, String> iParamReplacements = null;
    private volatile String iBaseurl = null;
    private volatile Map<String, Properties> iUrls = null;
    private DiskFileItemFactory iFileItemFactory = null;
    File iRepository = null;
    private static HttpClient client;
    volatile boolean iInitialized = false;
    private ConfigurationProperties iConfigurationProperties = null;
    private String sessionParam = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        InitServlet.setNDC((ServletContext)filterConfig.getServletContext());
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("initializing " + this.getClass().getName()));
        }
        this.iFileItemFactory = new DiskFileItemFactory();
        ServletContext servletContext = filterConfig.getServletContext();
        this.iRepository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        this.iFileItemFactory.setRepository(this.iRepository);
    }

    public void doInit() {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("initializing " + this.getClass().getName()));
        }
        this.iConfigurationProperties = ConfigurationProperties.get();
        this.iBaseurl = this.iConfigurationProperties.get2((Object)this, "baseurl");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Baseurl=" + this.iBaseurl));
        }
        this.iUrls = new HashMap<String, Properties>();
        nl.knowledgeplaza.util.Properties lProperties = this.iConfigurationProperties.getGroupedCollection("DocstoreFilter.urls");
        for (Object lKey : lProperties.keySet()) {
            this.iUrls.put((String)lKey, (Properties)lProperties.get(lKey));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Urls=" + this.iUrls));
        }
        this.sessionParam = this.iConfigurationProperties.get2((Object)this, "DocstoreFilter.sessionparam");
        if (this.sessionParam == null || this.sessionParam.isEmpty()) {
            this.sessionParam = "sid";
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Sessionparam=" + this.sessionParam));
        }
        this.iParamReplacements = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !DocstoreFilter.isMultipartContent((HttpServletRequest)request)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Not a file upload, pushing request up the chain");
            }
            chain.doFilter(request, response);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"request is back from the chain");
            }
            return;
        }
        HttpServletRequest lRequest = (HttpServletRequest)request;
        HttpServletResponse lResponse = (HttpServletResponse)response;
        DocstoreFilter docstoreFilter = this;
        synchronized (docstoreFilter) {
            if (!this.iInitialized) {
                this.doInit();
                this.iInitialized = true;
            }
        }
        Map<String, List<String>> lParameters = this.getParametersFromRequest((ServletRequest)lRequest);
        this.saveToDocstore(lRequest, lResponse, lParameters);
        Map<String, String[]> lParameters2 = this.createArrayVersionOfParameters(lParameters);
        HttpServletRequestWrapper lHttpServletRequestWrapper = this.createAnonymousRequestWrapper(lRequest, lParameters, lParameters2);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"File upload handled, now pushing request up the chain");
        }
        chain.doFilter((ServletRequest)lHttpServletRequestWrapper, (ServletResponse)lResponse);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"request is back from the chain");
        }
    }

    private void saveToDocstore(HttpServletRequest lRequest, HttpServletResponse lResponse, Map<String, List<String>> lParameters) throws IOException, ServletException {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("POST request=" + lRequest));
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)lRequest);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Is multipart=" + isMultipart));
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.iFileItemFactory);
        ArrayList<Object> lParts = new ArrayList<Object>();
        ArrayList<File> lFiles = new ArrayList<File>();
        String lUploadedFilename = null;
        try {
            List items = upload.parseRequest(lRequest);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Request parsed=" + items));
            }
            for (FileItem item : items) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("File item=" + item));
                }
                if (!item.isFormField()) {
                    String lFileName = item.getName();
                    File uploadedFile = new File(this.iRepository, lFileName);
                    lFiles.add(uploadedFile);
                    item.write(uploadedFile);
                    FilePart lPart = new FilePart(lFileName, uploadedFile);
                    lParts.add(lPart);
                    this.addValueToParameters(lParameters, item.getFieldName(), lFileName);
                    lUploadedFilename = lFileName;
                    continue;
                }
                this.handleParameter(lParameters, item);
                StringPart lPart = new StringPart(item.getFieldName(), item.getString());
                lParts.add(lPart);
            }
        }
        catch (Exception e) {
            log4j.warn((Object)"Error parsing request", (Throwable)e);
            lResponse.setStatus(500);
            return;
        }
        if (client == null) {
            client = new HttpClient();
        }
        String lPath = URIUtil.encodePathQuery((String)this.getDocstoreUrl(lRequest, lParameters, lUploadedFilename));
        PostMethod post = new PostMethod(lPath);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Call docstore with path:" + lPath));
        }
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(lParts.toArray(new Part[0]), post.getParams()));
        int postStatus = client.executeMethod((HttpMethod)post);
        for (File lFile : lFiles) {
            lFile.delete();
        }
        if (postStatus != 200 && postStatus != 302) {
            log4j.warn((Object)("Error send request to docstore, statuscode: " + postStatus));
            log4j.warn((Object)("Post returned: " + post.getResponseBodyAsString()));
            lResponse.setStatus(500);
            return;
        }
    }

    private HttpServletRequestWrapper createAnonymousRequestWrapper(HttpServletRequest lRequest, final Map<String, List<String>> lParameters, final Map<String, String[]> lParameters2) {
        for (String lKey : lParameters2.keySet()) {
            if (!lParameters.containsKey(lKey)) continue;
            lParameters.get(lKey).set(0, lParameters2.get(lKey)[0]);
        }
        HttpServletRequestWrapper lHttpServletRequestWrapper = new HttpServletRequestWrapper(lRequest){

            public String getParameter(String name) {
                List lValues = (List)lParameters.get(name);
                return lValues == null ? null : (String)lValues.get(0);
            }

            public Map<String, String[]> getParameterMap() {
                return Collections.unmodifiableMap(lParameters2);
            }

            public Enumeration<String> getParameterNames() {
                return new IteratorToEnumerationAdapter(lParameters.keySet().iterator());
            }

            public String[] getParameterValues(String name) {
                return (String[])lParameters2.get(name);
            }

            public String getContentType() {
                return "TEXT/PLAIN";
            }

            public int getContentLength() {
                return 0;
            }

            public ServletInputStream getInputStream() {
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return 0;
                    }
                };
            }
        };
        return lHttpServletRequestWrapper;
    }

    private Map<String, String[]> createArrayVersionOfParameters(Map<String, List<String>> lParameters) {
        TreeMap<String, String[]> lParameters2 = new TreeMap<String, String[]>();
        for (String lName : lParameters.keySet()) {
            if (this.iParamReplacements.containsKey(lName)) {
                lParameters2.put(lName, new String[]{this.iParamReplacements.get(lName)});
                if (!log4j.isDebugEnabled()) continue;
                log4j.debug((Object)("Replace " + lName + " with " + this.iParamReplacements.get(lName)));
                continue;
            }
            lParameters2.put(lName, lParameters.get(lName).toArray(new String[0]));
            if (!log4j.isDebugEnabled()) continue;
            log4j.debug((Object)("Keep " + lName + " with " + lParameters.get(lName)));
        }
        return lParameters2;
    }

    private void addValueToParameters(Map<String, List<String>> lParameters, String lName, String lValue) {
        if (lValue != null) {
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            lParameters.get(lName).add(lValue);
        }
    }

    private void handleParameter(Map<String, List<String>> lParameters, FileItem lPart) throws UnsupportedEncodingException {
        if (lPart.isFormField()) {
            String lName = lPart.getFieldName();
            String lValue = lPart.getString();
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("param; name=" + lName + ", value=" + lValue));
            }
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            lParameters.get(lName).add(lValue);
        }
    }

    private Map<String, List<String>> getParametersFromRequest(ServletRequest request) {
        TreeMap<String, List<String>> lParameters = new TreeMap<String, List<String>>();
        Enumeration lEnum = request.getParameterNames();
        while (lEnum.hasMoreElements()) {
            String lName = (String)lEnum.nextElement();
            String[] lValues = null;
            if (lName.equals(this.sessionParam) && request instanceof HttpServletRequest) {
                HttpServletRequest lRequest = (HttpServletRequest)request;
                String sessionId = lRequest.getSession().getId();
                lValues = new String[]{sessionId};
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("session parameter intercepted; name=" + lName + ", value=" + sessionId));
                }
            } else {
                lValues = request.getParameterValues(lName);
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("queryparam; name=" + lName + ", value=" + Arrays.asList(lValues)));
            }
            if (!lParameters.containsKey(lName)) {
                lParameters.put(lName, new ArrayList());
            }
            ((List)lParameters.get(lName)).addAll(Arrays.asList(lValues));
        }
        return lParameters;
    }

    public void destroy() {
    }

    /*
     * WARNING - void declaration
     */
    private String getDocstoreUrl(HttpServletRequest request, Map<String, List<String>> parameters, String uploadedFilename) {
        String lValue;
        String lAppUrl = request.getRequestURI().substring(request.getContextPath().length());
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("PIPE: Determining DOCSTORE url for: " + lAppUrl));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("PIPE: Determining DOCSTORE using: " + this.iUrls));
        }
        String lDocstoreUrl = null;
        String lDbQString = null;
        boolean getPath = false;
        String pathName = "";
        for (String string : this.iUrls.keySet()) {
            String lCandidateAppUrl = this.iUrls.get(string).getProperty("app");
            String lCandidateDocstoreUrl = this.iUrls.get(string).getProperty("docstore");
            String lCandidateDbQuery = this.iUrls.get(string).getProperty("pathQuery");
            if (lCandidateDbQuery == null) {
                lCandidateDbQuery = "";
            }
            if (!lCandidateAppUrl.equals(lAppUrl)) continue;
            lDocstoreUrl = lCandidateDocstoreUrl;
            lDbQString = lCandidateDbQuery;
        }
        String lUrl = this.iBaseurl + lDocstoreUrl;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("PIPE: Full docstore url: " + lUrl));
        }
        log4j.debug((Object)("PIPE: DB query: " + lDbQString));
        for (String lName : parameters.keySet()) {
            lValue = parameters.get(lName).get(0);
            if (!lValue.startsWith("WEET_NIET")) continue;
            getPath = true;
            pathName = lName;
        }
        for (String lName : parameters.keySet()) {
            lValue = parameters.get(lName).get(0);
            if (lValue.startsWith("WEET_NIET") || getPath && lName.equals("P_DOC_ID")) continue;
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("PIPE: replace %" + lName + "% with '" + lValue + "'"));
            }
            lUrl = lUrl.replaceAll("%" + lName + "%", lValue);
        }
        if (getPath) {
            void var10_18;
            String string = "";
            try {
                String tmpValue = this.getValueByQuery(lDbQString, parameters, uploadedFilename);
                if (tmpValue != null) {
                    String string2 = tmpValue;
                } else {
                    String string3 = new RandomGUID().toString();
                }
            }
            catch (QueryUtil.QueryUtilException e) {
                String msg = "Failed to get value by query";
                log4j.error((Object)msg, (Throwable)e);
                String string4 = new RandomGUID().toString();
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("PIPE: replace %" + pathName + "% with '" + (String)var10_18 + "'"));
            }
            lUrl = lUrl.replaceAll("%" + pathName + "%", (String)var10_18);
            String docId = this.iParamReplacements.get("P_DOC_ID");
            if (docId == null) {
                docId = "";
            }
            lUrl = lUrl.replaceAll("%P_DOC_ID%", docId);
            String lNewValue = parameters.get(pathName).get(0);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("PIPE: in " + pathName + " replace 'WEET_NIET' with '" + (String)var10_18 + "'"));
            }
            this.iParamReplacements.put(pathName, (String)var10_18);
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("PIPE: Full docstore url after replace: " + lUrl));
        }
        return lUrl;
    }

    public String getValueByQuery(String lDbQString, Map<String, List<String>> lParameters, String lUploadedFilename) throws QueryUtil.QueryUtilException {
        QueryUtil lQueryUtil = new QueryUtil();
        return lQueryUtil.getValueByQuery(lDbQString, lParameters, lUploadedFilename, this.iParamReplacements);
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    class DocstoreThreadFactory
    implements ThreadFactory {
        DocstoreThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread lThread = new Thread(r);
            lThread.setName("DocstoreServlet " + lThread.getName());
            lThread.setDaemon(true);
            return lThread;
        }
    }
}

